<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCusOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cus_orders', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedBigInteger('item_id');
            $table->unsignedBigInteger('cus_id');
            $table->string('attribute');
            $table->integer('qty');
            $table->integer('pro_amount');
            $table->integer('reseller_cost');
            $table->string('barcode');
            $table->foreign('item_id')->references('id')->on('order_items');
            $table->foreign('cus_id')->references('id')->on('customers');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cus_orders');
    }
}
