@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Bulk Orders Import</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Bulk Orders Import</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                @if ($message = Session::get('success'))
					<div class="alert alert-success" role="alert">
						{{ Session::get('success') }}
					</div>
				@endif


				@if ($message = Session::get('error'))
					<div class="alert alert-danger" role="alert">
						{{ Session::get('error') }}
					</div>
				@endif
            </div>
        </div>
        <div class="row">
            <div class="col-md-10"><p style="color:red;">Order Upload Template Was Changed. Please Download The New Template.</p></div>
            <div class="col-md-2"><a href="uploads/bulk_import.xlsx" class="btn btn-block btn-warning" download>Download Template</a>
            </div>
        </div> <br><hr><br>
        <form action="{{ URL::to('postbulkimport') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="">Select Excel sheet</label> <br>
                    <input type="file" name="import_file" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel"/>
                </div>
            </div>




            <div class="col-md-3" style="padding-top:30px;"><button type="submit" id="submitbutton" class="btn btn-block btn-primary">Import Orders</button></div>
        </div>

        <div class="row">
            <div class="col-md-1"></div>

        </div>   <br><br>
        <div class="row">
            <div class="col-md-4"></div>
            
            <div class="col-md-4"></div>
        </div> 
        </form>       
      </div>
    </div>
      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size:13px;">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>City</th>
                            <th>COD</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>
            </div>
          </div>
          </div>
        </div>

    <div class="card">
        <div class="card-body">

          <div class="row">
          <div class="col-md-3"></div>
          <div class="col-md-2"><a type="submit" style="float: right;" class="btn btn-block btn-danger delallorders">Delete All</a></div>
            <div class="col-md-2"><a type="submit"  class="btn btn-block btn-primary sentocallcenter">Send Call Center</a></div>
            <div class="col-md-2"><a type="submit"  class="btn btn-block btn-dark sendtosellercenter">Send to Seller Center</a></div>
            <div class="col-md-2"></div>
          </div>
          <br>



        </div>
      </div>


      <div class="card">
        <div class="card-body">
        <form method="post" action="/tempordersdown">
        {{csrf_field()}}
        <div class="row">
            <div class="col-md-4">
                <h3> Failed Orders</h3><br>
            </div>
            <div class="col-md-4">
               
            </div>
            <div class="col-md-2">
                <button type="submit" name="delete" value="delete" class="btn btn-danger btn-block">Failed Orders Delete</button>
            </div>
            <div class="col-md-2">
                <button type="submit" name="download" value="download" class="btn btn-warning btn-block">Excel Download</button>
            </div>
        </div>
        </form>
          <div class="row">
            <div class="col-md-12">
                <table id="example14" data-page-length='50' class="table table-bordered" style="width:100%; font-size:11px;">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Address</th>
                            <th>City</th>
                            <th>Tel 1</th>
                            <th>Tel 2</th>
                            <th>Item</th>
                            <th>QTY</th>
                            <th>Price</th>
                            <th>Delivery</th>
                            <th>COD</th>
                            <th>Error Code</th>
                        </tr>
                    <tbody>
                        @foreach($tempo as $data)
                        <tr>
                            <td>{{$data->name}}</td>
                            <td>{{$data->address}}</td>
                            <td>{{$data->city}}</td>
                            <td>{{$data->tp_1}}</td>
                            <td>{{$data->tp_2}}</td>
                            <td>{{$data->item}}</td>
                            <td>{{$data->qty}}</td>
                            <td>{{$data->unit_price}}</td>
                            <td>{{$data->delivery}}</td>
                            <td>{{$data->total}}</td>
                            <td>{{$data->error_code}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                    </thead>
                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 


<div class="modal fade" id="editordermodelphone" role="dialog">
        <div class="modal-dialog">
        
          <!-- Modal content-->
          <div class="modal-content">
            <div class="modal-header">
                    <h4 class="modal-title">City Update</h4>
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              
            </div>
            
            <form method="post" enctype="multipart/form-data" id="myform">
            {{csrf_field()}}
                <div class="modal-body">
                <input type="hidden" id="id" name="id">

               <div class="form-group">
                        <label>City :</label>
                    <select class="form-control select2" name="cituselect" id="cituselect">
                        <option value="empty" selected="selected" disabled>Select</option>
                        @foreach($city as $cityd)
                        <option value="{{ $cityd->id }}">{{ $cityd->city }}</option>
                        @endforeach
                    </select>
                </div> 
                    
                </div>
                  
            <div class="modal-footer">
            <input type="submit" name="btnform1" id="action" class="btn btn-primary right" value="Submit"/>
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
            </form>
          </div>
          
        </div>

</div>







  @include('dashboard.include.footer');

<script>
$('#editordermodelphone').on('show.bs.modal', function (event) {

var button = $(event.relatedTarget) // Button that triggered the modal

var id = button.data('id') 
var city = button.data('city') 

var modal = $(this)
//   modal.find('.modal-title').text('New message to ' + recipient)
modal.find('.modal-body #id').val(id)
$("#cituselect").val(city).change();

})


$('#myform').on('submit', function(event){
    let ele = this;
        event.preventDefault();
        var form_data = $(this).serialize();
        $.ajax({
            url:"/importcityupdate",
            method:"POST",
            data:form_data,
            dataType:"json",      
            success: function (result, code, ex) {
                // swal("Done!", "It was successfully!", "success");
                toastr.success('City Update successfully!')
                $("#editordermodelphone").modal('hide');  
                $('#example12').DataTable().ajax.reload();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                swal("Warning", "Unable to Process your request", "error");
            },
            
        })
    });



  $(document).ready(function() {
    $('#example14').DataTable();
} );

$(function () {
    $('.select2').select2()
})


$(document).ready(function() {
    $('#example12').DataTable({
        processing: false,
        serverSide: true,
        responsive: true,
        ajax: '/bulkpendingorders',
        columns: [
            { data: 'id', name: 'id' },
            // {  data: 'pagename', name: 'pagename' },
            {  data: 'name', name: 'name' },
            { data: 'address', name: 'address'},
            { data: 'phone', name: 'phone'},
            { data: 'citydata', 
              render: function(data) { 
                if(data==0) {
                  return '<span class="badge badge-danger">No select City</span>' 
                   }
                   else{
                    return data
                   }
                },
              defaultContent: '<span class="badge badge-warning">No select City</span>'
            },
            { data: 'cod', name: 'cod'},
            { data: 'action', name: 'action', orderable: false, searchable: false}
        ]
    });


} );
</script>
<script>
 $(document).on('click', '.sendtosellercenter', function (e) {
    e.preventDefault();
    let ele = this;
                swal({
                title: "Are you sure?",
                text: "Are you Sure to Change Order Status",
                icon: "warning",
                showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Change!',
                dangerMode: true,
            }).then(function(isConfirm) {
                
                if (isConfirm.value===true) {

                        $.ajax({
                            url: "{{url('/sendtosellercenter2')}}" ,
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            cache: false,
                            contentType: false,
                            processData: false,
                            dataType: 'JSON',
                            success: function (data) {
                                swal("Done!", "It was successfully!", "success");
                                $('#example12').DataTable().ajax.reload();
                                location.reload();

                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                swal("Warning", "Unable to Process your request", "error");
                            },
                        });

                } else {
                    swal("Cancelled", "No Change Order Status", "error");
                }
            })
});







$(document).on('click', '.bulkdelete', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    console.log(id);

                swal({
                title: "Are you sure?",
                text: "Are you Sure to Remove Order",
                icon: "warning",
                showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, delete it!',
                dangerMode: true,
            }).then(function(isConfirm) {
                
                if (isConfirm.value===true) {

                        $.ajax({
                            url: "{{url('/deletecustomer')}}/"+id ,
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            cache: false,
                            contentType: false,
                            processData: false,
                            dataType: 'JSON',
                            data:{
                                "id":id
                            },
                            success: function (result, code, ex) {
                                swal("Done!", "It was successfully deleted!", "success");
                                // $(ele).closest('tr').hide();
                                $('#example12').DataTable().ajax.reload();
                                // $("#here").load(location.href + " #here");
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                swal("Warning", "Unable to Process your request", "error");
                            },
                        });

                } else {
                    swal("Cancelled", "No Removed", "error");
                }
            })
});


 $(document).on('click', '.sentocallcenter', function (e) {
    e.preventDefault();
    let ele = this;
                swal({
                title: "Are you sure?",
                text: "Are you Sure to Change Order Status",
                icon: "warning",
                showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Change!',
                dangerMode: true,
            }).then(function(isConfirm) {
                
                if (isConfirm.value===true) {

                        $.ajax({
                            url: "{{url('/sentocallcenter2')}}" ,
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            cache: false,
                            contentType: false,
                            processData: false,
                            dataType: 'JSON',
                            success: function (data) {
                                swal("Done!", "It was successfully!", "success");
                                $('#example12').DataTable().ajax.reload();
                                location.reload();

                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                swal("Warning", "Unable to Process your request", "error");
                            },
                        });

                } else {
                    swal("Cancelled", "No Change Order Status", "error");
                }
            })
});



 $(document).on('click', '.delallorders', function (e) {
    e.preventDefault();
    let ele = this;
                swal({
                title: "Are you sure?",
                text: "Are you Sure to Remove All Orders",
                icon: "warning",
                showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Delete!',
                dangerMode: true,
            }).then(function(isConfirm) {
                
                if (isConfirm.value===true) {

                        $.ajax({
                            url: "{{url('/deletebulkcustomer')}}" ,
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            cache: false,
                            contentType: false,
                            processData: false,
                            dataType: 'JSON',
                            success: function (data) {
                                swal("Done!", "It was successfully!", "success");
                                $('#example12').DataTable().ajax.reload();
                                location.reload();

                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                swal("Warning", "Unable to Process your request", "error");
                            },
                        });

                } else {
                    swal("Cancelled", "No removed", "error");
                }
            })
});

</script>
