@include('dashboard.include.header')

  
  <div class="content-wrapper" style="">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">2nd Attempt Orders</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">2nd Attempt Orders</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table data-page-length='25' id="example12" class="table table-striped table-hover" style="width:100%; font-size:12px;">
                <thead>
                        <tr>
                            <th>Name</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Product</th>
                            <th>COD</th>
                            <th>Action</th>
                        </tr>
                        <tbody>
                            @foreach($item as $data)
                            <tr>
                                <td>{{$data->name}}</td>
                                <td>{{$data->address}}</td>
                                <td>{{$data->phone}}</td>
                                <td>
                                @foreach($data->cus_or as $pro)
                                  {{$pro->orders->pro_name}},
                                @endforeach
                                </td>
                                <td>{{$data->cod}}</td>
                                <td>
                                @if($data->lockstatus == 1)
                                <span class="badge badge-warning">{{$data->lockuser}} in use</span>&nbsp;&nbsp;<a class="resetlockscreen" data-id="{{$data->id}}" href=""><i class="fas fa-sync"></i></a>
                                @else
                                  <a class="btn bg-gradient-primary btn-xs" href="viewaddorder/{{$data->id}}">view</a>
                                @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </thead>
                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer')



<script>

  $(document).ready(function() {
    $('#example12').DataTable();
} );

$(document).on('click', '.resetlockscreen', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    $.ajax({
        url: "{{url('/resetlock')}}/"+id ,
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'JSON',
        data:{
            "id":id
        },
        success: function (result, code, ex) {
            // swal("Done!", "It was successfully deleted!", "success");
            // $(ele).closest('tr').hide();
            toastr.success('Lock Order Reset successfully')
            location.reload();
        },
        error: function (jqXHR, textStatus, errorThrown) {
            swal("Warning", "Unable to Process your request", "error");
        },
    });

});
</script>








