@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Dropex Dispatch Orders</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Dropex Dispatch Orders</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
            <table id="example1" data-page-length='50' class="table table-bordered" style="width:100%; font-size:12px;">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Delivery Date</th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>City</th>
                            <th>Phone</th>
                            <th>items</th>
                            <th>COD</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($item as $data)
                        <tr>
                            <td>{{$data->id}}</td>
                            <td>{{$data->deliverydate}}</td>
                            <td>{{$data->name}}</td>
                            <td>{{$data->address}}</td>
                            <td>{{$data->getcity->city}}</td>
                            <td>{{$data->phone}}</td>
                            <td>@foreach($data->cus_or as $itemdata)
                                    {{$itemdata->orders->name}},
                                @endforeach 
                            </td>
                            <td>@if($data->paymentmethod=="paid")0.00 @else{{$data->cod}}@endif</td>
                            <td class="text-center">                            
                                <a data-id="{{$data->id}}" class="btn btn-primary btn-xs" href="viwedetailsship/{{$data->id}}">View</a>
                            </td>
                            
                        </tr>
                    @endforeach 
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Id</th>
                            <th>Delivery Date</th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>City</th>
                            <th>Phone</th>
                            <th>items</th>
                            <th>COD</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');

<script>
$(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false,
      "buttons": [ "colvis", "excel"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
  });
</script>