@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Remind Orders</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Remind Orders</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/remindfilter">
          {{csrf_field()}}

        <div class="row">

            <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                  <div class="input-group date" id="reservationdate" data-target-input="nearest">
                        <input type="text" class="form-control datetimepicker-input" value="{{$dateran}}" id="delivery_date" name="delivery_date" data-target="#reservationdate"/  required>
                        <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-1" style="padding-top:32px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>
        </div>
        </form>
        <br><hr><br>
        <form action="{{ URL::to('bulkremindorderupload') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row">
        <div class="col-md-3"></div>

            <div class="col-md-3">
                <div class="form-group">
                    <label for="">Select Excel sheet</label>- "waybill" <br>
                    <input type="file" name="import_file" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel"/>
                </div>
            </div>
            <div class="col-md-3" style="padding-top:30px;"><button type="submit" name="Reshedule" value="Reshedule" id="submitbutton" class="btn btn-block btn-primary">Upload Reshedule Orders</button></div>
            <div class="col-md-3" style="padding-top:30px;"><button type="submit" name="Fail" value="Fail" id="submitbutton" class="btn btn-block btn-primary">Upload Fail to delivery Orders</button></div>
        </div>
        </form>
      </div>
    </div>

      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
            <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size:13px;">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Waybill</th>
                            <th>Courier Name</th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Product</th>
                            <th>COD</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($item as $data)
                        <tr>
                            <td>{{$data->id}}</td>
                            <td>{{$data->tracking}}</td>
                            @if($data->deliveryservice != "-")
                            <td>{{$data->deliveryse->deliveryname}}</td>
                            @else
                            <td>{{$data->userget->name}}</td>
                            @endif
                            <td>{{$data->name}}</td>
                            <td>{{$data->phone}}</td>
                            <td>@foreach($data->cus_or as $itemdata)
                                    {{$itemdata->orders->pro_name}},
                                @endforeach 
                            </td>
                            <td>{{$data->cod}}</td>
                            <td>
                              @if($data->deliverystatus == 30)<span class="badge badge-primary">Reshedule Orders</span>
                              @elseif($data->deliverystatus == 46)<span class="badge badge-danger">Fail to delivery</span>
                              @endif
                            </td>
                            <td class="text-center">                            
                                <a data-id="{{$data->id}}" target="_blank" class="btn btn-primary btn-xs" href="viewallorders/{{$data->id}}">View</a>
                            </td>
                            
                        </tr>
                    @endforeach 
                    </tbody>
                    <tfoot>
                        <tr>
                          <th>Id</th>
                          <th>Waybill</th>
                          <th>Courier Name</th>
                          <th>Name</th>
                          <th>Phone</th>
                          <th>Product</th>
                          <th>COD</th>
                          <th>Status</th>
                          <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');

<script>
$(document).ready(function() {
    $('#example12').DataTable();
} );

    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('#reservationdate').datetimepicker({
format: 'YYYY/MM/DD'
});

</script>