@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Courier Payment Summary</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Courier Payment Summary</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/courierpaymentsummaryfilter">
          {{csrf_field()}}
          <div class="row">
            <div class="col-md-3">
                  <div class="form-group">
                      <label>Select Delivery Service</label>
                      <select class="form-control" name="delivery" id="delivery" style="width: 100%;" required>
                          <option value="" selected="selected" disabled>Select</option>
                              @foreach($delise as $data)
                              <option value="{{ $data->id }}" @if($del==$data->id) selected @else @endif>{{ $data->deliveryname }}</option>
                              @endforeach
                      </select>
                  </div>
              </div>

              <div class="col-md-1" style="padding-top:30px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>


          </div>
          </form>
        </div>
      </div>




      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size:11px;">
                <thead>
                            <tr>
                                <th>Delivery Company</th>
                                <th>COD Amount</th>
                                <th>Delivery Charge</th>
                                <th>Payable Amount</th>
                                <th>Payment ID</th>
                                <th>Paid Date</th>
                                <th>Status</th>
                                <th>Action</th>

                            </tr>
                        </thead>
                        <tbody>
                        @if($del == "null")
                        @else
                        @foreach($cuso as $coudata)
                            <tr>
                            <td>{{ $coudata->deliveryrecivemoneyget->deliveryname}}</td>
                            <td>{{ $coudata->codamount}}</td>
                            <td>{{ $coudata->deliverycharge}}</td>
                            <td>{{ $coudata->payablecod}}</td>
                            <td>{{ $coudata->courierpaymentid}}</td>
                            <td>{{ $coudata->paidat}}</td>
                            <td class="text-center">
                                @if($coudata->status=='0')
                                <span class="badge badge-warning">Not Paid</span>
                                @elseif($coudata->status=='1')
                                <span class="badge badge-success">Paid</span>
                                @endif
                                </td>
                                <td class="text-center">               
                                    <a data-id="{{$coudata->id}}" class="btn btn-primary btn-xs" href="receivedetails/{{$coudata->id}}">View</a>                                                                                                                                                                 
                                </td>  
                            </tr>
                        @endforeach
                        @endif
                        </tbody>
                    </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},      
    ]  
    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });
</script>