@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Missing Parcel</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Missing Parcel</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/notreceivedmoneyfilter">
          {{csrf_field()}}
          <div class="row">
          <div class="col-md-6">
            <div class="form-group">
                  <label>Delivery Partner</label>
                  <select class="select2" multiple="multiple" name="delivery[]" id="delivery"  data-placeholder="Delivery Partner" style="width: 100%;" required>
                    @foreach($delise as $data)
                       <option value="{{ $data->id }}" @foreach($del as $deldata) @if($deldata==$data->id) selected @else @endif @endforeach>{{ $data->deliveryname }}</option>
                    @endforeach
                  </select>
                </div>
            </div>

              <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                  <div class="input-group">
                      <div class="input-group-prepend">
                      <span class="input-group-text">
                          <i class="far fa-calendar-alt"></i>
                      </span>
                      </div>
                      <input type="text" class="form-control float-right" id="reservation" value="{{$date}}" name="daterange">
                  </div>
                  </div>
              </div>
              <div class="col-md-3" style="padding-top:30px;">
                <button type="submit" name="Filter" value="Filter" class="btn btn-primary btn-block">Not Received Money Orders Filter</button>
            </div>
            <div class="col-md-3">
                <button type="submit" formtarget="_blank" name="PDF" value="PDF" class="btn btn-dark btn-block">Not Received Money Orders PDF</button>
            </div>
            <div class="col-md-2">
                <button type="submit" name="Missing" value="Missing" class="btn btn-primary btn-block">Missing Orders Filter</button>
            </div>
            <div class="col-md-2">
                <button type="submit" formtarget="_blank" name="MissingPDF" value="MissingPDF" class="btn btn-dark btn-block">Missing Orders PDF</button>
            </div>
          </div>
          </form>
        </div>
      </div>




      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size:11px;">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Waybill</th>
                            <th>Courier Service</th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Product</th>
                            <th>COD</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($item as $data)
                        <tr>
                            <td>{{$data->id}}</td>
                            <td>{{$data->tracking}}</td>
                            <td>
                            @foreach($delise as $deldata)
                            @if($data->deliveryservice == $deldata->id)
                                @if($data->deliveryservice == 1 OR $data->deliveryservice == 2)
                                <span class="badge badge-info"> {{$deldata->deliveryname}}</span>
                                @elseif($data->deliveryservice == 3 OR $data->deliveryservice == 4)
                                <span class="badge badge-danger"> {{$deldata->deliveryname}}</span>
                                @elseif($data->deliveryservice == 5 OR $data->deliveryservice == 6)
                                <span class="badge badge-warning"> {{$deldata->deliveryname}}</span>
                                @elseif($data->deliveryservice == 7 OR $data->deliveryservice == 8)
                                <span class="badge badge-dark"> {{$deldata->deliveryname}}</span>
                                @else
                                <span class="badge badge-danger"> {{$deldata->deliveryname}}</span>
                                @endif
                            @break;
                            @endif
                            @endforeach
                            </td>
                            <td>{{$data->name}}</td>
                            <td>{{$data->address}}</td>
                            <td>{{$data->phone}}</td>
                            <td>@foreach($data->cus_or as $itemdata)
                                    @if(empty($itemdata->orders->pro_name))
                                    -
                                    @else
                                    {{$itemdata->orders->pro_name}},
                                    @endif
                                @endforeach 
                            </td>
                            <td>{{$data->cod}}</td>
                            <td class="text-center">                            
                                <a data-id="{{$data->id}}" target="_blank" class="btn btn-primary btn-xs" href="viewallorders/{{$data->id}}">View</a>
                            </td>
                            
                        </tr>
                    @endforeach 
                    </tbody>

                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},      
    ]  
    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });


    $('.select2').select2()
</script>