@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Orders Status Summary</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Orders Status Summary</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/ordersstatusfilter">
          {{csrf_field()}}
          <div class="row">

          <div class="col-md-5">
                <div class="form-group">
                    <label>Product Name</label>
                    <select class="form-control select2" name="product_d" id="product_d" style="width: 100%;" required>
                        <option value="" selected="selected" disabled>Select</option>
                        @foreach($product as $productdata)
                            <option value="{{$productdata->id}}" @if($del==$productdata->id) selected @endif >{{$productdata->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-3">
                  <div class="form-group">
                      <label>Order Source</label>
                      <select class="form-control" name="source" id="source">
                          <option value="Facebook Leads" @if($sou=="Facebook Leads") selected @endif >Facebook Leads</option>
                          <option value="Facebook Message" @if($sou=="Facebook Message") selected @endif >Facebook Message</option>                            
                          <option value="Whatsapp" @if($sou=="Whatsapp") selected @endif >Whatsapp</option>                            
                          <option value="Call Order" @if($sou=="Call Order") selected @endif >Call Order</option>                            
                          <option value="Store Pickup" @if($sou=="Store Pickup") selected @endif >Store Pickup</option>                            
                          <option value="Web Order" @if($sou=="Web Order") selected @endif >Web Order</option>                            
                      </select>
                  </div>
              </div>
              <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                  <div class="input-group">
                      <div class="input-group-prepend">
                      <span class="input-group-text">
                          <i class="far fa-calendar-alt"></i>
                      </span>
                      </div>
                      <input type="text" class="form-control float-right" id="reservation" value="{{$ldate}}" name="daterange">
                  </div>
                  </div>
              </div>
              <div class="col-md-1" style="padding-top:30px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>


          </div>
          </form>
        </div>
      </div>




      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size:13px;">
                    <thead>
                        <tr>
                            <th>Product Name</th>
                            <th>Order Source</th>
                            <th>Status</th>
                            <th>Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($del=="null")
  
                            @else
                            @foreach($dataor as $data)
                            <tr>
                              <td>{{$data->name}}</td>
                              <td>{{$data->ordersource}}</td>
                              <td>
                               @if($data->status =='0')   
                                Check Order
                                @elseif($data->status =='1')   
                                Pending
                                @elseif($data->status =='2')               
                                1st Attempt
                                @elseif($data->status =='3')                
                                2nd Attempt
                                @elseif($data->status =='4')               
                                3rd Attempt
                                @elseif($data->status =='5')            
                               Colombo Confirm           
                                @elseif($data->status =='6')                
                               Out Confirm
                                @elseif($data->status =='7')                
                                Return Order
                                @elseif($data->status =='8')                
                                Dispatched Order
                                @elseif($data->status =='9')                
                                Money Received Order
                                @elseif($data->status =='10')                
                                Cancel Order
                                @elseif($data->status =='11')                
                               Out Assigned
                                @elseif($data->status =='12')                
                               Colombo Assigned
                                @elseif($data->status =='13')                
                               Out Pick
                                @elseif($data->status =='14')                
                               Colombo Pick
                                @elseif($data->status =='15')                
                               Packed
                                @elseif($data->status =='16')                
                               Phone Off
                                @elseif($data->status =='17')                
                               He will call
                                @elseif($data->status =='18')                
                               Delivered
                                @elseif($data->status =='19')                
                               Dropex Confirm
                                @elseif($data->status =='20')                
                               Dropex Dispatched
                                @elseif($data->status =='26')                
                               Hold
                                @elseif($data->status =='27')                
                               Reject
                                @elseif($data->status =='28')                
                                Banned Customer
                                @elseif($data->status =='29')                
                                Incomplete Order
                                @elseif($data->status =='30')                
                                Reschedule Order
                                @elseif($data->status =='31')                
                                WebStore Dispatched
                                @endif
                              
                              
                              </td>
                              <td>{{$data->count}}</td>
                              </tr>
                            @endforeach
                            @endif     

                        
                    </tbody>

                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 1, "DESC" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3]}},      
    ]  
    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('.select2').select2()
</script>