@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Remaining Stock</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Remaining Stock</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
            <table id="example12" data-page-length='100' class="table table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Product Name</th>
                        <th>Sell Price</th>
                        <th>Cost</th>
                        <th>Reseller Price</th>
                        <th>Weight</th>
                        <th>Stock</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($product as $data)
                    <tr>
                        <td>{{$data->id}}</td>
                        <td>{{$data->name}}</td>
                        <td>{{$data->sell_price}}</td>
                        <td>{{$data->cost_price}}</td>                
                        <td>{{$data->resellerprice}}</td>                
                        <td>{{$data->weight}}</td>                
                        <td>{{$data->stock}}</td>                              
                    </tr>
                @endforeach 
                </tbody>
                <tfoot>
                    <tr>
                        <th>Id</th>
                        <th>Product Name</th>
                        <th>Sell Price</th>
                        <th>Cost</th>
                        <th>Reseller Price</th>
                        <th>Weight</th>
                        <th>Stock</th>
                    </tr>
                </tfoot>
            </table>
            
            </div>
          </div>
          </div>
        </div>
      </div>
    </section>
  </div>
 




  @include('dashboard.include.footer')

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 4, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4]}},      
    ],
    columnDefs: [
            {
                "targets": 3, // your case first column
                "className": "text-center",
                "width": "4%"
        },
        {
                "targets": 2,
                "className": "text-center",
        },

        ],

    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('.select2').select2()
</script>