@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Track Order Status</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Track Order Status</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/usertrackreportfilter">
          {{csrf_field()}}
          <div class="row">
            <div class="col-md-3">
                  <div class="form-group">
                      <label>User Name</label>
                      <select class="form-control select2" name="delivery" id="delivery" style="width: 100%;" required>
                          <!-- <option value="" selected="selected" disabled>Select</option> -->
                          <option value="01">All</option>

                              @foreach($delise as $data)
                              @if($data->email=="admin@admin.com")
                              @else
                              <option value="{{ $data->name }}" @if($del==$data->name) selected @else @endif>{{ $data->name }}</option>
                              @endif
                              @endforeach
                      </select>
                  </div>
              </div>
              <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                  <div class="input-group">
                      <div class="input-group-prepend">
                      <span class="input-group-text">
                          <i class="far fa-calendar-alt"></i>
                      </span>
                      </div>
                      <input type="text" class="form-control float-right" id="reservation" value="{{$date}}" name="daterange">
                  </div>
                  </div>
              </div>
              <div class="col-md-1" style="padding-top:30px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>


          </div>
          </form>
        </div>
      </div>




      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size:13px;">
                    <thead>
                        <tr>
                            <th>User Name</th>
                            <th>Computer Name</th>
                            <th>Status</th>
                            <th>#Invoice</th>
                            <th>Date & Time</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if($del=="null")
     
                            @else
                            @foreach($item as $data)
                            <tr>
                            <td>{{ $data->username }}</td>
                            <td>{{ $data->starttime }}</td>                            
                            <td>
                                @if($data->orderstatus =='5')            
                                <span class="badge badge-dark">Colombo Confirm</span>                  
                                @elseif($data->orderstatus =='6')                
                                <span class="badge badge-info">Out Confirm</span>
                                @elseif($data->orderstatus =='19')                
                                <span class="badge badge-warning">Dropex Confirm</span>
                                @elseif($data->orderstatus =='10')                
                                <span class="badge badge-danger">Cancel Order</span>
                                @endif
                            </td> 

                            <td><a data-id="{{$data->id}}" target="_blank" href="viewallorders/{{$data->customerid}}">{{ $data->customerid }}</a></td>   
                            <td>{{ $data->created_at }}</td> 
                            </tr>
                            @endforeach  
                            @endif                          
                       
                    </tbody>

                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4]}},      
    ],
    columnDefs: [
            {
                "targets": 3, // your case first column
                "className": "text-center",
                "width": "4%"
        },
        {
                "targets": 2,
                "className": "text-center",
        },

        ],

    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('.select2').select2()
</script>