@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Bank Transaction Summary</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Bank Transaction Summary</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
        <form method="post" action="/transactionsummaryfilter" class="formFilter">
          {{csrf_field()}}
          <div class="row">


            <div class="col-md-4">
              <div class="form-group">
                <label>Select Bank</label>
                <select class="form-control" name="bank" id="bank" style="width: 100%;" required>
                    <option value="" selected="selected" disabled>Select</option>
                    @foreach($supdata as $supdatadata)
                        <option value="{{$supdatadata->id}}" @if($supdatadata->id == $bank) selected @endif >{{$supdatadata->accountname}} - {{$supdatadata->bank}}</option>
                    @endforeach
                </select>
            </div>
            </div>

            <div class="col-md-4">
              <div class="form-group">
                <label>Account Option</label>
                <select class="form-control" name="accoption" id="accoption" style="width: 100%;" required>
                        <option value="all">All</option>
                    @foreach($accoption as $accoptiondata)
                        <option value="{{$accoptiondata->option}}" @if($accoptiondata->option == $acc) selected @endif >{{$accoptiondata->option}}</option>
                    @endforeach
                </select>
            </div>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                    <span class="input-group-text">
                        <i class="far fa-calendar-alt"></i>
                    </span>
                    </div>
                    <input type="text" class="form-control float-right" id="reservation" value="{{$date}}" name="daterange">
                </div>
                </div>

            </div>
            <div class="col-md-1" style="padding-top:30px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>

          </div>
          </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

          <div class="row">
            <div class="col-md-12">
            <table id="example12" data-page-length='100' class="table table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Date</th>
                        <th>Description</th>
                        <th>Debit</th>
                        <th>Credit</th>
                        <th>Balance</th>
                    </tr>
                </thead>
                <tbody>
                @if($acc=="null")
     
                @else
                @foreach($item as $data)
                    <tr>
                        <td>{{ $data->id }}</td>
                        <td>{{ $data->created_at }}</td>
                        <td>{{ $data->note }}</td>
                        <td>{{ $data->withdrawal }}</td>
                        <td>{{ $data->deposit }}</td>
                        <td>{{ $data->balance }}</td>
                    </tr>
                @endforeach
                @endif
                </tbody>

            </table>
            
            </div>
          </div>
          </div>
        </div>
      </div>
    </section>
  </div>
 




  @include('dashboard.include.footer')

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},      
    ],


    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('.select2').select2()
</script>