@include('dashboard.include.header')
@if(Auth::user()->type == "User")
<script>
    document.location.href = '/resellerdash'
</script>
@endif
  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Payment Summary</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Payment Summary</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <div class="row">
                <div class="col-md-3">
                    <div class="callout callout-info">
                    <h5>{{$totcod+$extotcod}}</h5>
                    <p>Total Collected COD</p>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="callout callout-primary">
                    <h5>{{$mondel}}</h5>
                    <p>Delivery Charge</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="callout callout-warning">
                    <h5>{{$totinventory}}</h5>
                    <p>Products Charge</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="callout callout-danger">
                    <h5>{{$servicech}}</h5>
                    <p>Service Charge</p>
                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="callout callout-refund">
                    <h5>{{$totrefundcod}}</h5>
                    <p>Refund charge</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="callout callout-dark">
                    <h5>{{$totcommi}}</h5>
                    <p>Commission</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="callout callout-advance">
                    <h5>{{$totadvance}}</h5>
                    <p>Advance</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="callout callout-success">
                    <h5>{{ ($totcod + $extotcod + $totcommi) - $totrefundcod - $totinventory - $totadvance -($mondel+$servicech) }}</h5>
                    <p>Payable COD</p>
                    </div>
                </div>
            </div> 
            <br><hr><br>
            <div class="col-md-12">
                <table id="example12" class="table table-bordered" style="width:100%;">
                    <thead>
                        <tr>
                            <th>Invoice ID</th>
                            <th>Status</th>
                            <th>Weight (KG)</th>
                            <th>COD</th>
                            <th>Delivery Charge</th>
                            <th>Service Charge</th>
                            <th>Product Charge</th>
                            <th>Net Payable</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($money as $data)
                        @php $deli=0; $tot=0; $unit=0; @endphp
                        @foreach($data->cus_or as $cudata) 
                            @php
                            $unit = ($cudata->reseller_cost)*($cudata->qty);
                            $tot += $unit;
                            @endphp
                        @endforeach
                        <tr>
                            <td><a target="_blank"  href="/viewallorders/{{$data->id}}">{{$data->id}}</a></td>
                            <td>
                            @if($data->ordertype == 1)
                            <span class="badge badge-success">Money Received</span>
                            @elseif($data->ordertype == 2)
                            <span class="badge badge-warning">Exchange Order</span>
                            @endif
                            </td>
                            <td>{{$data->weight}}</td>
                            <td>{{$data->cod}}</td>
                            <td>{{$data->orderdelivery}}</td>
                            <td>{{$data->servicecharge}}</td>
                            <td>{{$tot}}</td>
                            <td>{{$data->cod - ($data->orderdelivery+$data->servicecharge+$tot) }}</td>
                        </tr>
                        @endforeach

                        @foreach($exchange as $data)
                        @php $deli=0; $tot=0; $unit=0; @endphp
                        @foreach($data->cus_or as $cudata) 
                            @php
                            $unit = ($cudata->reseller_cost)*($cudata->qty);
                            $tot += $unit;
                            @endphp
                        @endforeach
                        <tr>
                            <td><a target="_blank"  href="/viewallorders/{{$data->id}}">{{$data->id}}</a></td>
                            <td>
                            @if($data->ordertype == 1)
                            <span class="badge badge-success">Money Received</span>
                            @elseif($data->ordertype == 2)
                            <span class="badge badge-warning">Exchange Order</span>
                            @endif
                            </td>
                            <td>{{$data->weight}}</td>
                            <td>{{$data->cod}}</td>
                            <td>0</td>
                            <td>{{$data->servicecharge}}</td>
                            <td>0</td>
                            <td>{{$data->cod - ($data->servicecharge) }}</td>
                        </tr>
                        @endforeach

                        @foreach($return as $data)
                        <tr>
                            <td><a target="_blank"  href="/viewallorders/{{$data->id}}">{{$data->id}}</a></td>
                            <td><span class="badge badge-danger">Return Order</span></td>
                            <td>{{$data->weight}}</td>
                            <td>0</td>
                            <td>0</td>
                            <td>{{$data->servicecharge}}</td>
                            <td>0</td>
                            <td>{{0 - $data->servicecharge }}</td>
                        </tr>
                        @endforeach

                        @foreach($refund as $data)
                        <tr>
                            <td><a target="_blank"  href="/viewallorders/{{$data->id}}">{{$data->id}}</a></td>
                            <td><span class="badge badge-dark">Refund Order</span></td>
                            <td>{{$data->weight}}</td>
                            <td>-{{$data->cod}}</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>{{0 - $data->cod }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

    <br><br><hr><br><br>
            <div class="col-md-12">
            <h4>Advance</h4>
                <table id="example12" class="table table-bordered" style="width:100%; font-size:13px;">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Advance</th>
                            <th>Paid ID</th>
                            <th>Date of Paid to the Reseller</th>
                            <th>Paid Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($advance as $addata)
                          <tr>
                            <td>{{ $addata->id }}</td>
                            <td>{{ $addata->advance }}</td>
                            <td>{{ $addata->paidid }}</td>
                            <td>{{ $addata->created_at }}</td>
                            <td>{{ $addata->paiddate }}</td>
                          </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
<br><br><hr><br><br>
            <div class="col-md-12">
            <h4>Commision</h4>
                <table id="example12" class="table table-bordered" style="width:100%; font-size:13px;">
                    <thead>
                        <tr>
                            <th>Company Name</th>
                            <th>Commision Charge</th>
                            <th>Orders Count</th>
                            <th>Total Commision</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($comdetails as $data2)
                          <tr>
                            <td>{{ $data2['resname'] }}</td>
                            <td>{{ $data2['charge'] }}</td>
                            <td>{{ $data2['count'] }}</td>
                            <td>{{ $data2['total'] }}</td>
                          </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>



        </div>
        </div>
      

     

      </div>
    </section>
  </div>




  @include('dashboard.include.footer');

<script>
$('#reservationdate').datetimepicker({
    format: 'YYYY/MM/DD'
    });

$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},      
    ],


    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );

</script>