@include('dashboard.include.header')

  
  <div class="content-wrapper" style="">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">City Update</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">City Update</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <form method="post" action="/cityupfilter">
          {{csrf_field()}}
          <div class="row">
            <div class="col-md-4">
              <div class="form-group">
                <label>Filter Orders by Delivery Service</label>
                <select class="form-control" name="resellerid" id="resellerid" style="width: 100%;" required>
                    <option value="" selected="selected" disabled>Select</option>
                    @foreach($delivery as $userdata)
                    <option value="{{$userdata->id}}" @if($userdata->id == $del) selected @endif>{{$userdata->deliveryname}}</option>
                    @endforeach
                </select>
            </div>
            </div>
            <div class="col-md-1" style="padding-top:30px;"><button type="submit" class="btn btn-block btn-primary">Filter</button> </div>
          </div>
          </form>
        </div>
      </div>
      <form method="post" id="formFilter" class="formFilter">
          {{csrf_field()}}
          <input type="hidden" value="{{$del}}" name="resellerid">
        </form>


      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table data-page-length='500' id="example12" class="table table-striped table-hover" style="width:100%; font-size:12px;">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>City</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>
            </div>
          </div><br><br>
        <form method="post" action="/sendoutprint">
        {{csrf_field()}}
        <div class="row">
            <input type="hidden" name="delservice" id="delservice" value="{{$del}}">
            <div class="col-md-2"><button type="submit" name="adddelivery" value="adddelivery" class="btn btn-primary btn-block">Send to Out Print</button></div>
        </div>
        </form>

          </div>
        </div>

      </div>
    </section>
  </div>
 

<div class="modal fade" id="editordermodelphone" role="dialog">
        <div class="modal-dialog">
        
          <!-- Modal content-->
          <div class="modal-content">
            <div class="modal-header">
                    <h4 class="modal-title">City Update</h4>
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              
            </div>
            
            <form method="post" class="deliveryupform">
            {{csrf_field()}}
                <div class="modal-body">
                <input type="hidden" id="id" name="id">

               <div class="form-group">
                        <label>City :</label>
                    <select class="form-control select2" name="cituselect" id="cituselect">
                        @foreach($city as $cityd)
                        <option value="{{ $cityd->id }}">{{ $cityd->city_name }}</option>
                        @endforeach
                    </select>
                </div> 
                    
                </div>
                  
            <div class="modal-footer">
            <input type="submit" class="btn btn-primary right" value="Submit"/>
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
            </form>
          </div>
          
        </div>

</div>

  @include('dashboard.include.footer')



<script>
$(function () {
    $('.select2').select2()
})


$('#resellerid').change(function() {
    var min = $(this).val();
    $('#example12').DataTable().ajax.reload();
});

$(document).ready(function() {
  var table = $('#example12').DataTable({
        "ajax": {   "url": '/cityupdatedatatable',
                    "type": 'POST',
                    "data": function ( d ) {
                    return $('.formFilter').serialize();
                    }
        },
        columns: [
            { data: 'id', name: 'id' },
            { data: 'name', name: 'name' },
            { data: 'address', name: 'address'},
            { data: 'citydata', 
              render: function(data) { 
                if(data==0) {
                  return '<span class="badge badge-danger">No select City</span>' 
                   }
                   else{
                    return data
                   }
                },
              defaultContent: '<span class="badge badge-warning">No select City</span>'
            },
            { data: 'action', name: 'action', orderable: false, searchable: false}
        ],
    });
} );

$('#editordermodelphone').on('show.bs.modal', function (event) {

var button = $(event.relatedTarget) // Button that triggered the modal

var id = button.data('id') 
var city = button.data('city') 
var modal = $(this)
//   modal.find('.modal-title').text('New message to ' + recipient)
modal.find('.modal-body #id').val(id)
$("#cituselect").val(city).change();

});

$('.deliveryupform').on('submit', function(event){
    let ele = this;
        event.preventDefault();
        var form_data = $(this).serialize();
        $.ajax({
            url:"/trancecityupdate",
            method:"POST",
            data:form_data,
            dataType:"json",      
            success: function (result, code, ex) {
                // swal("Done!", "It was successfully!", "success");
                toastr.success('City Update successfully!')
                $("#editordermodelphone").modal('hide');  
                $('#example12').DataTable().ajax.reload();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                swal("Warning", "Unable to Process your request", "error");
            },
            
        })
    });




@if (session('success'))
        //swal("Success!","{{session('success')}}","success");

Swal.fire({
  
  type: 'success',
  title: 'Your work has been saved',
  text: "{{session('success')}}",
  showConfirmButton: false,
  timer: 1500
});


@endif
@if (session('error'))
    swal({
            title: "Error!",
            text: "{{session('error')}}",
            icon: "error",
            button: "OK",
        });
@endif
</script>








