@include('dashboard.include.header')

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Manage Reseller</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Manage Reseller</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <section class="content">
      <div class="container-fluid">
        <table id="example" class="table table-striped table-bordered" style="width:100%">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Company</th>
                            <th>Email </th>
                            <th>Role</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($item as $data)
                    @if($data->email=="admin@admin.com")
                    @else
                        <tr>
                            <td>{{ $data->name}}</td>
                            <td>{{ $data->getresellerd->companyname}}</td>
                            <td>{{ $data->email}}</td>
                            <td class="text-center">@if($data->type=="Reseller") Reseller Admin @else {{ $data->type}} @endif</td>
                            <td class="text-center">
                                <button type="button" class="btn btn-primary btn-sm" data-branch="{{$data->resellerid}}" data-id="{{$data->id}}" data-name="{{$data->name}}" data-email="{{$data->email}}"  data-role="{{$data->type}}" data-toggle="modal" data-target="#updatepagemodel">Edit</button>
                                <a href="" data-id="{{$data->id}}" class="btn btn-danger btn-sm button" data-url="">Delete </a>
                            </td>                        
                        </tr>
                        @endif
                    @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Name</th>
                            <th>Company</th>
                            <th>Email </th>
                            <th>Role</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>    
      </div>
    </section>
  </div>
 


    <div class="modal fade" id="updatepagemodel" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle">User Details Change</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <form class="form-horizontal" method="POST" action="/resellerupdateuser">
            {{csrf_field()}}
        <div class="modal-body"> 
            <input type="hidden" name="id" id="id">           
        <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
            <label for="name" class="col-md-4 control-label">Name</label>
                <input id="name" type="text" class="form-control" name="name" value="{{ old('name') }}" required autofocus>
                @if ($errors->has('name'))
                    <span class="help-block">
                        <strong>{{ $errors->first('name') }}</strong>
                    </span>
                @endif
        </div>
        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
            <label for="email" class="col-md-4 control-label">E-Mail Address</label>
                <input id="email" type="email" class="form-control" name="email" value="{{ old('email') }}" required>
                @if ($errors->has('email'))
                    <span class="help-block">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif
        </div>
        <div class="form-group">
        <label for="type" class="col-md-4 control-label" >User Type:</label>

                <select class="form-control" name="type" id="type">
                    <option value="Reseller">Reseller Admin</option>   
                </select>
        </div>
        <div class="form-group">
            <label class="control-label" for="type">Reseller Name:</label>
                <select class="form-control" name="resellerid" id="resellerid">
                    @foreach($reseld as $redata)
                    <option value="{{ $redata->id }}">{{ $redata->companyname }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save changes</button>
        </div>
        </form>
        </div>
    </div>
</div>
  

  @include('dashboard.include.footer');

<script>
$(document).ready(function() {
    $('#example').DataTable();
} );

$('#updatepagemodel').on('show.bs.modal', function (event) {

var button = $(event.relatedTarget) // Button that triggered the modal
var recipient = button.data('id') 
var name = button.data('name') 
var email = button.data('email') 
var role = button.data('role') 
var res = button.data('branch') 


var modal = $(this)
modal.find('.modal-body #id').val(recipient)
modal.find('.modal-body #name').val(name)
modal.find('.modal-body #email').val(email)
$("#type").val(role).change();
$("#resellerid").val(res).change();

})




$(document).on('click', '.btn-danger', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;

            swal({
            title: "Are you sure?",
            text: "Are you Sure to Remove this User",
            icon: "warning",
            showCancelButton: true,
confirmButtonColor: '#3085d6',
cancelButtonColor: '#d33',
confirmButtonText: 'Yes, delete it!',
            dangerMode: true,
        }).then(function(isConfirm) {
            
            if (isConfirm.value===true) {

                    $.ajax({
                        url: "{{url('/deleteuser')}}/"+id ,
                        method: "POST",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: 'JSON',
                        data:{
                            "id":id
                        },
                        success: function (result, code, ex) {
                            swal("Done!", "It was successfully deleted!", "success");
                            $(ele).closest('tr').hide();
                            // $("#here").load(location.href + " #here");
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            swal("Warning", "Unable to Process your request", "error");
                        },
                    });

            } else {
                swal("Cancelled", "Not Removed User", "error");
            }
        })
});
</script>