<!DOCTYPE html>
<html class="no-js" lang="en">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <title>SellerCenter</title>
    <meta name="robots" content="noindex, follow" />
    <meta name="description" content="" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1, shrink-to-fit=no"
    />
    <!-- Favicon -->
    <link
      rel="shortcut icon"
      type="image/x-icon"
      href="{{ asset('front/assets/images/favicon.png') }}"
    />
    <link rel="stylesheet" href="{{ asset('dash/plugins/toastr/toastr.min.css') }}">
    <link rel="stylesheet" href="{{ asset('dash/plugins/sweetalert2/sweetalert2.min.css') }}">

    <!-- CSS
	============================================ -->

    <!-- Vendor CSS (Icon Font) -->
    <!--
    <link rel="stylesheet" href="assets/css/vendor/font-awesome-pro.min.css">
    <link rel="stylesheet" href="assets/css/vendor/pe-icon-7-stroke.css">
    <link rel="stylesheet" href="assets/css/vendor/muli-font.css"> -->

    <!-- Plugins CSS (All Plugins Files) -->
    <!--
    <link rel="stylesheet" href="assets/css/plugins/swiper.min.css">
    <link rel="stylesheet" href="assets/css/plugins/animate.css">
    <link rel="stylesheet" href="assets/css/plugins/aos.min.css">
    <link rel="stylesheet" href="assets/css/plugins/magnific-popup.css">
    <link rel="stylesheet" href="assets/css/plugins/jquery.animatedheadline.css">
     -->

    <!-- Main Style CSS -->
    <!-- <link rel="stylesheet" href="assets/css/style.css"> -->

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <link rel="stylesheet" href="{{ asset('front/assets/css/vendor/vendor.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('front/assets/css/plugins/plugins.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('front/assets/css/style.css') }}" />

    <style>
      #hero-z {
        background: url("{{ asset('front/assets/images/hero-image/hero-2.jpg') }}") center center
          fixed;
        background-size: cover;
        position: relative;
        overflow: hidden;
        background-attachment: fixed;
      }

      #hero-z::before {
        content: "";
        background: rgba(0, 0, 0, 0.5); /* Adjust opacity as needed */
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -5;
      }
    </style>
  </head>

  <body>
    <div id="page" class="section">
      <!-- Header Section Start -->
      <div class="header-section header-transparent sticky-header section">
        <div class="header-inner">
          <div class="container position-relative">
            <div class="row justify-content-between align-items-center">
              <!-- Header Logo Start -->
              <div class="col-xl-2 col-auto order-0">
                <div class="header-logo">
                  <a href="/">
                    <img
                      class="dark-logo"
                      src="{{ asset('front/assets/images/logo/logo.png') }}"
                      alt="Agency Logo"
                    />
                  </a>
                </div>
              </div>
              <!-- Header Logo End -->

              <!-- Header Main Menu Start -->
              <div
                class="col-auto col-xl d-flex align-items-center justify-content-xl-center justify-content-end order-2 order-xl-1 p-4"
              >
                <div class="menu-column-area d-none d-xl-block position-static">
                  <nav class="site-main-menu">
                    <ul>
                      <li>
                        <a href="/"
                          ><span class="menu-text">Home</span></a
                        >
                      </li>
                      <li>
                        <a href="#about"
                          ><span class="menu-text">About Us</span></a
                        >
                      </li>

                      <li>
                        <a href="#contact"
                          ><span class="menu-text">Contact Us</span></a
                        >
                      </li>

 

                      <li>
                        <a href="#register"><span class="menu-text">Register</span></a>
                      </li>
                      <li>
                        <a href="/login" class="prevent-default"
                          ><span class="menu-text">Login</span></a
                        >
                      </li>
                    </ul>
                  </nav>
                </div>

                <!-- Header Mobile Menu Toggle Start -->
                <div class="header-mobile-menu-toggle d-xl-none ml-sm-2">
                  <button class="toggle">
                    <i class="icon-top"></i>
                    <i class="icon-middle"></i>
                    <i class="icon-bottom"></i>
                  </button>
                </div>
                <!-- Header Mobile Menu Toggle End -->
              </div>
              <!-- Header Main Menu End -->

              <!-- Header Right Start -->
              <div
                class="col-xl-2 col d-none d-sm-flex justify-content-end order-1 order-xl-2"
              >
                <a
                  href="/login"
                  class="btn btn-light btn-hover-primary"
                  >Login</a
                >
              </div>
              <!-- Header Right End -->
            </div>
          </div>
        </div>
      </div>
      <!-- Header Section End -->

      <!--Hero section Start-->
      <section id="hero-z" class="d-flex align-items-center">
        <div class="container mb-6 mt-25">
          <div class="row justify-content-center">
            <div
              class="intro-content-two col-lg-8 text-center mb-6 mt-lg-20 mt-md-6 mt-sm-6 mt-6"
            >
              <h1 class="title">Grow Your Business with Ease</h1>
              <div class="desc">
                <p>
                  Seller Center simplifies dropshipping, allowing you to focus
                  on expanding your business without the worries of inventory
                  and shipping.
                </p>

                <!--video start-->
                <a
                  href="{{ asset('front/assets/media/video/local-video.mp4') }}"
                  class="play-btn icon video-popup"
                  ><i class="fas fa-play"></i
                ></a>
                <!--video end-->
              </div>
            </div>
          </div>

          <div
            class="row row-cols-lg-5 row-cols-md-3 row-cols-sm-2 justify-content-center d-flex flex-wrap"
          >
            <!-- Icon Box Start -->
            <div
              class="col mb-6 d-flex aos-init aos-animate"
              data-aos="fade-up"
            >
              <div
                class="icon-box box-border d-flex flex-column align-items-center justify-content-center"
                data-vivus-hover=""
                style="background-color: transparent; color: white"
              >
                <div class="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="{{ asset('front/assets/images/svg/linea/linea-basic-target.svg') }}"
                    class="svgInject"
                  >
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M53.92,10.081c12.107,12.105,12.107,31.732,0,43.838  c-12.106,12.108-31.734,12.108-43.84,0c-12.107-12.105-12.107-31.732,0-43.838C22.186-2.027,41.813-2.027,53.92,10.081z"
                      style="stroke-dasharray: 195, 197; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M9.001000000000001,32A22.999,22.999 0,1,1 54.998999999999995,32A22.999,22.999 0,1,1 9.001000000000001,32"
                      style="stroke-dasharray: 145, 147; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M17,32A15,15 0,1,1 47,32A15,15 0,1,1 17,32"
                      style="stroke-dasharray: 95, 97; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M25.001,32A6.999,6.999 0,1,1 38.999,32A6.999,6.999 0,1,1 25.001,32"
                      style="stroke-dasharray: 44, 46; stroke-dashoffset: 0"
                    ></path>
                  </svg>
                </div>
                <div>
                  <h6 class="text text-center" style="color: white">
                    Zero Investment
                  </h6>
                </div>
              </div>
            </div>
            <!-- Icon Box End -->

            <!-- Register with Seller Center -->
            <div
              class="col mb-6 d-flex aos-init aos-animate"
              data-aos="fade-up"
            >
              <div
                class="icon-box box-border d-flex flex-column align-items-center justify-content-center"
                data-vivus-hover=""
                style="background-color: transparent; color: white"
              >
                <div class="icon">
                  <svg
                    enable-background="new 0 0 64 64"
                    height="64"
                    viewBox="0 0 64 64"
                    width="64"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <g
                      fill="none"
                      stroke="#000"
                      stroke-miterlimit="10"
                      stroke-width="2"
                    >
                      <path d="m42 15v46h-41v-58h29z" />
                      <path d="m55 1v53l4 8 4-8v-53z" />
                      <path d="m8 13h12" />
                      <path d="m8 23h27" />
                      <path d="m8 31h27" />
                      <path d="m8 39h27" />
                      <path d="m8 47h27" />
                      <path d="m42 15h-12v-12" />
                      <path d="m55 11h8" />
                    </g>
                  </svg>
                </div>
                <div>
                  <h6 class="text text-center" style="color: white">
                    Register with Seller Center
                  </h6>
                </div>
              </div>
            </div>

            <!-- Find Products -->
            <div
              class="col mb-6 d-flex aos-init aos-animate"
              data-aos="fade-up"
            >
              <div
                class="icon-box box-border d-flex flex-column align-items-center justify-content-center"
                data-vivus-hover=""
                style="background-color: transparent; color: white"
              >
                <div class="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                  >
                    <g
                      fill="none"
                      stroke="#000000"
                      stroke-miterlimit="10"
                      stroke-width="2"
                    >
                      <path
                        d="M1,21A20,20 0,1,1 41,21A20,20 0,1,1 1,21"
                        style="stroke-dasharray: 126, 128; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m35 35 6 6"
                        style="stroke-dasharray: 9, 11; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m46.257 37.065h8.485v26.87h-8.485z"
                        transform="matrix(-.7071 .7071 -.7071 -.7071 121.9178 50.5)"
                        style="stroke-dasharray: 71, 73; stroke-dashoffset: 0"
                      ></path>
                    </g>
                  </svg>
                </div>
                <div>
                  <h6 class="text text-center" style="color: white">
                    Find Products
                  </h6>
                </div>
              </div>
            </div>

            <!-- Upload the products to your online store -->
            <div
              class="col mb-6 d-flex aos-init aos-animate"
              data-aos="fade-up"
            >
              <div
                class="icon-box box-border d-flex flex-column align-items-center justify-content-center"
                data-vivus-hover=""
                style="background-color: transparent; color: white"
              >
                <div class="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="{{ asset('front/assets/images/svg/linea/linea-basic-picture-multiple.svg') }}"
                    class="svgInject"
                  >
                    <g>
                      <path
                        fill="none"
                        stroke="#000000"
                        stroke-width="2"
                        stroke-miterlimit="10"
                        width="52"
                        height="40"
                        d="M1 16 L53 16 L53 56 L1 56 Z"
                        style="stroke-dasharray: 184, 186; stroke-dashoffset: 0"
                      ></path>
                    </g>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M10,14L10,8L63,8L63,48L55,48"
                      style="stroke-dasharray: 107, 109; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M1,46L15,32L29,48L39,42L53,54"
                      style="stroke-dasharray: 72, 74; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M35,29A5,5 0,1,1 45,29A5,5 0,1,1 35,29"
                      style="stroke-dasharray: 32, 34; stroke-dashoffset: 0"
                    ></path>
                  </svg>
                </div>
                <div>
                  <h6 class="text text-center" style="color: white">
                    Upload the products to your online store
                  </h6>
                </div>
              </div>
            </div>

            <!-- Sell products to your customers -->
            <div
              class="col mb-6 d-flex aos-init aos-animate"
              data-aos="fade-up"
            >
              <div
                class="icon-box box-border d-flex flex-column align-items-center justify-content-center"
                data-vivus-hover=""
                style="background-color: transparent; color: white"
              >
                <div class="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.0"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="{{ asset('front/assets/images/svg/linea/linea-ecommerce-cart-plus.svg') }}"
                    class="svgInject"
                  >
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M14,57A6,6 0,1,1 26,57A6,6 0,1,1 14,57"
                      style="stroke-dasharray: 38, 40; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M38,57A6,6 0,1,1 50,57A6,6 0,1,1 38,57"
                      style="stroke-dasharray: 38, 40; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M26,57L38,57"
                      style="stroke-dasharray: 12, 14; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M14,57L10,2L0,2"
                      style="stroke-dasharray: 66, 68; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M13,43L56,40L63,10L11,10"
                      style="stroke-dasharray: 126, 128; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M36,17L36,35"
                      style="stroke-dasharray: 18, 20; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M45,26L27,26"
                      style="stroke-dasharray: 18, 20; stroke-dashoffset: 0"
                    ></path>
                  </svg>
                </div>
                <div>
                  <h6 class="text text-center" style="color: white">
                    Sell products to your customers
                  </h6>
                </div>
              </div>
            </div>

            <!-- Get Your Profit -->
            <div
              class="col mb-6 d-flex aos-init aos-animate"
              data-aos="fade-up"
            >
              <div
                class="icon-box box-border d-flex flex-column align-items-center justify-content-center"
                data-vivus-hover=""
                style="background-color: transparent; color: white"
              >
                <div class="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="{{ asset('front/assets/images/svg/linea/linea-ecommerce-euro.svg') }}"
                  >
                    <!-- Corrected paths -->
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M53.92,10.081c12.107,12.105,12.107,31.732,0,43.838 c-12.106,12.108-31.734,12.108-43.84,0c-12.107-12.105-12.107-31.732,0-43.838C22.186-2.027,41.813-2.027,53.92,10.081z"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M42,43c0,0-1,4-10,4s-12-7-12-15s3-15,12-15 s10,4,10,4"
                    ></path>
                    <line
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      x1="15"
                      y1="30"
                      x2="34"
                      y2="30"
                    ></line>
                    <line
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      x1="15"
                      y1="34"
                      x2="34"
                      y2="34"
                    ></line>
                  </svg>
                </div>
                <div>
                  <h6 class="text text-center" style="color: white">
                    Get Your Profit
                  </h6>
                </div>
              </div>
            </div>
            <!-- Icon Box End -->
          </div>
        </div>
      </section>
      <!--Hero section End-->

      <!-- counterdown section start-->
      <div
        class="section section-padding"
        data-bg-color="#f8faff"
        style="background-color: rgb(248, 250, 255)"
      >
        <div class="container">
          <div class="row">
            <div class="col-lg-12 mx-auto">
              <div
                class="row row-cols-lg-3 row-cols-md-2 row-cols-sm-2 row-cols-1 mb-n6"
              >
                <!-- Funfact Start -->

                <!-- Funfact End -->

                <!-- Funfact Start -->
                <div class="col mb-6 aos-init aos-animate" data-aos="fade-up">
                  <div class="funfact">
                    <div class="number"><span class="counter">100</span>+</div>
                    <div class="desc px-5">
                      <h6 class="text">Brands</h6>
                      <p class="sub-title">
                        Many Varieties Of Brands In Our Inventory
                      </p>
                    </div>
                  </div>
                </div>
                <!-- Funfact End -->

                <!-- Funfact Start -->
                <div class="col mb-6 aos-init aos-animate" data-aos="fade-up">
                  <div class="funfact">
                    <div class="number"><span class="counter">2000</span>+</div>
                    <div class="desc px-5">
                      <h6 class="text">Products</h6>
                      <p class="sub-title">
                        More Than 2000 Products In Our Inventory
                      </p>
                    </div>
                  </div>
                </div>
                <!-- Funfact End -->

                <!-- Funfact Start -->
                <div class="col mb-6 aos-init aos-animate" data-aos="fade-up">
                  <div class="funfact">
                    <div class="number"><span class="counter">100</span>+</div>
                    <div class="desc px-5">
                      <h6 class="text">Reseller</h6>
                      <p class="sub-title">
                        More Than 100 Currently Engaged Resellers
                      </p>
                    </div>
                  </div>
                </div>
                <!-- Funfact End -->
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- counter section End -->

      <!-- About Section Start -->
      <div
        id="about"
        class="section section-padding-t90 section-padding-bottom-200"
      >
        <div class="container">
          <!-- Section Title Start -->
          <div class="section-title text-center pt-15" data-aos="fade-up">
            <h2 class="title">Who We Are</h2>
            <p class="sub-title">
              At Seller Center, we make dropshipping easy for entrepreneurs. We
              offer a platform where business owners can grow without worrying
              about inventory or shipping. Our goal is to help you focus on what
              you do best.
            </p>
          </div>
          <!-- Section Title End -->

          <!-- About Wrapper Start -->
          <div class="row">
            <!-- About Image Area Start -->
            <div class="col-xl-7 col-lg-6 col-12" data-aos="fade-up">
              <div class="about-image-area">
                <div class="about-image js-tilt">
                  <img
                    src="{{ asset('front/assets/images/about/home-one-about/home_agency_about_1.jpg') }}"
                    alt=""
                  />
                </div>
                <div class="about-image js-tilt">
                  <img
                    src="{{ asset('front/assets/images/about/home-one-about/home_agency_about_2.jpg') }}"
                    alt=""
                  />
                </div>
                <!-- Animation Shape Start -->
                <div class="shape shape-1 scene">
                  <span data-depth="1"
                    ><img
                      src="{{ asset('front/assets/images/shape-animation/about-shape-1.png') }}"
                      alt=""
                  /></span>
                </div>
                <!-- Animation Shape End -->
              </div>
            </div>
            <!-- About Image Area Start -->

            <!-- About Start -->
            <div class="col-xl-5 col-lg-6 col-12" data-aos="fade-up">
              <!-- About Content Area Start -->
              <div class="about-content-area">
                <!-- Section Title Two Start -->
                <div class="section-title-two">
                  <span class="sub-title"
                    >fostering your dreams passionately</span
                  >
                  <h3 class="title">Our Story</h3>
                </div>
                <!-- Section Title Two End -->

                <p>
                  We are here to empower entrepreneurs. At Seller Center, we are
                  more than a dropshipping service; we are your partner. Our
                  reliable dropshipping solutions help you build your business
                  with confidence. Join us and discover how straightforward and
                  rewarding running a successful business can be.
                </p>

                <a
                  class="btn btn-primary btn-hover-secondary mt-xl-8 mt-lg-8 mt-md-6 mt-4"
                  href="#"
                  >About Us</a
                >
              </div>
              <!-- About Content Area Start -->
            </div>
            <!-- About Start -->
          </div>
          <!-- About Wrapper End -->
        </div>
      </div>
      <!-- About Section End -->

      <!--how this work section start-->
      <div class="section section-padding-t90-b100" data-bg-color="#f8faff">
        <div class="container">
          <!-- Section Title Start -->
          <div class="section-title text-center mb-12" data-aos="fade-up">
            <h2 class="title">How We Work</h2>
            <p class="sub-title">
              Get your company heading in the right direction with our digital
              marketing strategist
            </p>
          </div>
          <!-- Section Title End -->

          <div class="row row-cols-1 d-flex flex-column">
            <!--Asiri Icon Box start-->
            <div class="col mb-6" data-aos="fade-up">
              <div class="icon-box d-md-flex p-2" data-vivus-hover>
                <div class="icon mx-5">
                  <svg
                    enable-background="new 0 0 64 64"
                    height="64"
                    viewBox="0 0 64 64"
                    width="64"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <g
                      fill="none"
                      stroke="#000"
                      stroke-miterlimit="10"
                      stroke-width="2"
                    >
                      <path
                        d="m42 15v46h-41v-58h29z"
                        style="stroke-dasharray: 191, 193; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m55 1v53l4 8 4-8v-53z"
                        style="stroke-dasharray: 132, 134; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m8 13h12"
                        style="stroke-dasharray: 12, 14; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m8 23h27"
                        style="stroke-dasharray: 27, 29; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m8 31h27"
                        style="stroke-dasharray: 27, 29; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m8 39h27"
                        style="stroke-dasharray: 27, 29; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m8 47h27"
                        style="stroke-dasharray: 27, 29; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m42 15h-12v-12"
                        style="stroke-dasharray: 24, 26; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m55 11h8"
                        style="stroke-dasharray: 8, 10; stroke-dashoffset: 0"
                      ></path>
                    </g>
                  </svg>
                </div>
                <div>
                  <h3 class="title">
                    Register with Seller Center and obtain access to our platform
                  </h3>

                  <p class="desc">
                    This will allow you to access our product catalogue with a
                    wide variety of products and to manage your account
                  </p>
                </div>
              </div>
            </div>
            <!--Asiri Icon box end-->

            <!--Asiri Icon Box start-->
            <div class="col mb-6" data-aos="fade-up">
              <div class="icon-box d-md-flex p-2" data-vivus-hover>
                <div class="icon mx-5">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                  >
                    <g
                      fill="none"
                      stroke="#000000"
                      stroke-miterlimit="10"
                      stroke-width="2"
                    >
                      <path
                        d="M1,21A20,20 0,1,1 41,21A20,20 0,1,1 1,21"
                        style="stroke-dasharray: 126, 128; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m35 35 6 6"
                        style="stroke-dasharray: 9, 11; stroke-dashoffset: 0"
                      ></path>
                      <path
                        d="m46.257 37.065h8.485v26.87h-8.485z"
                        transform="matrix(-.7071 .7071 -.7071 -.7071 121.9178 50.5)"
                        style="stroke-dasharray: 71, 73; stroke-dashoffset: 0"
                      ></path>
                    </g>
                  </svg>
                </div>
                <div>
                  <h3 class="title">Find products</h3>

                  <p class="desc">
                    Search our catalog of Hundreds of products for products that
                    fit your niche
                  </p>
                </div>
              </div>
            </div>
            <!--Asiri Icon box end-->

            <!--Asiri Icon Box start-->
            <div class="col mb-6" data-aos="fade-up">
              <div class="icon-box d-md-flex p-2" data-vivus-hover>
                <div class="icon mx-5">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="{{ asset('front/assets/images/svg/linea/linea-basic-picture-multiple.svg') }}"
                    class="svgInject"
                  >
                    <g>
                      <path
                        fill="none"
                        stroke="#000000"
                        stroke-width="2"
                        stroke-miterlimit="10"
                        width="52"
                        height="40"
                        d="M1 16 L53 16 L53 56 L1 56 Z"
                        style="stroke-dasharray: 184, 186; stroke-dashoffset: 0"
                      ></path>
                    </g>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M10,14L10,8L63,8L63,48L55,48"
                      style="stroke-dasharray: 107, 109; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M1,46L15,32L29,48L39,42L53,54"
                      style="stroke-dasharray: 72, 74; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M35,29A5,5 0,1,1 45,29A5,5 0,1,1 35,29"
                      style="stroke-dasharray: 32, 34; stroke-dashoffset: 0"
                    ></path>
                  </svg>
                </div>
                <div>
                  <h3 class="title">
                    Upload the products to your online store
                  </h3>

                  <p class="desc">
                    Easily upload to your online stores or pages. We will
                    provide customized graphic work and other support related to
                    this
                  </p>
                </div>
              </div>
            </div>
            <!--Asiri Icon box end-->

            <!--Asiri Icon Box start-->
            <div class="col mb-6" data-aos="fade-up">
              <div class="icon-box d-md-flex p-2" data-vivus-hover>
                <div class="icon mx-5">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.0"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="{{ asset('front/assets/images/svg/linea/linea-ecommerce-cart-plus.svg') }}"
                    class="svgInject"
                  >
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M14,57A6,6 0,1,1 26,57A6,6 0,1,1 14,57"
                      style="stroke-dasharray: 38, 40; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M38,57A6,6 0,1,1 50,57A6,6 0,1,1 38,57"
                      style="stroke-dasharray: 38, 40; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M26,57L38,57"
                      style="stroke-dasharray: 12, 14; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M14,57L10,2L0,2"
                      style="stroke-dasharray: 66, 68; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M13,43L56,40L63,10L11,10"
                      style="stroke-dasharray: 126, 128; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M36,17L36,35"
                      style="stroke-dasharray: 18, 20; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M45,26L27,26"
                      style="stroke-dasharray: 18, 20; stroke-dashoffset: 0"
                    ></path>
                  </svg>
                </div>
                <div>
                  <h3 class="title">
                    Sell to your customers, then buy from sellercenter
                  </h3>

                  <p class="desc">
                    Promote and Sell the products at retail price to your
                    customers through and place the confirmed orders with us
                    through our platform.
                  </p>
                </div>
              </div>
            </div>
            <!--Asiri Icon box end-->

            <!--Asiri Icon Box start-->
            <div class="col mb-6" data-aos="fade-up">
              <div class="icon-box d-md-flex p-2" data-vivus-hover>
                <div class="icon mx-5">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="https://htmldemo.net/exomac/exomac/assets/images/svg/linea/linea-basic-map.svg"
                    class="svgInject"
                  >
                    <g>
                      <path
                        fill="none"
                        stroke="#000000"
                        stroke-width="2"
                        stroke-miterlimit="10"
                        d="M1,59L22,51L42,59L63,51L63,5L42,13L22,5L1,13Z"
                        style="stroke-dasharray: 225, 227; stroke-dashoffset: 0"
                      ></path>
                      <g>
                        <path
                          fill="none"
                          stroke="#000000"
                          stroke-width="2"
                          stroke-miterlimit="10"
                          d="M22,5L22,51"
                          style="stroke-dasharray: 46, 48; stroke-dashoffset: 0"
                        ></path>
                      </g>
                      <g>
                        <path
                          fill="none"
                          stroke="#000000"
                          stroke-width="2"
                          stroke-miterlimit="10"
                          d="M42,13L42,59"
                          style="stroke-dasharray: 46, 48; stroke-dashoffset: 0"
                        ></path>
                      </g>
                    </g>
                  </svg>
                </div>
                <div>
                  <h3 class="title">
                    Your customer receives the product directly from us
                  </h3>

                  <p class="desc">
                    We will handle the packing, delivery and cash collection
                    related to the order and settle your margin back to your
                    account on a timely manner
                  </p>
                </div>
              </div>
            </div>
            <!--Asiri Icon box end-->

            <!--Asiri Icon Box start-->
            <div class="col mb-6" data-aos="fade-up">
              <div class="icon-box d-md-flex p-2" data-vivus-hover>
                <div class="icon mx-5">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="{{ asset('front/assets/images/svg/linea/linea-ecommerce-euro.svg') }}"
                  >
                    <!-- Corrected paths -->
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M53.92,10.081c12.107,12.105,12.107,31.732,0,43.838 c-12.106,12.108-31.734,12.108-43.84,0c-12.107-12.105-12.107-31.732,0-43.838C22.186-2.027,41.813-2.027,53.92,10.081z"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M42,43c0,0-1,4-10,4s-12-7-12-15s3-15,12-15 s10,4,10,4"
                    ></path>
                    <line
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      x1="15"
                      y1="30"
                      x2="34"
                      y2="30"
                    ></line>
                    <line
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      x1="15"
                      y1="34"
                      x2="34"
                      y2="34"
                    ></line>
                  </svg>
                </div>
                <div>
                  <h3 class="title">Sell again. Profit again</h3>

                  <p class="desc">
                    Find more products for your customers and close more deals
                  </p>
                </div>
              </div>
            </div>
            <!--Asiri Icon box end-->
          </div>
        </div>
      </div>
      <!--how this work section end-->

      <!-- Sign Up form start-->
      <div
        class="section section-padding-t110-b120 newsletter-section"
        data-bg-color="#000"
        data-overlay="0.7"
        data-bg-image="{{ asset('front/assets/images/bg/newsletter.jpg') }}"
        style="
          background-image: url('{{ asset('front/assets/images/bg/newsletter.jpg') }}');
          background-color: rgb(0, 0, 0);
        "
      >
        <div class="container">
          <div class="row align-items-center">
            <div class="col-lg-12">
              <!-- Newsletter Content Start -->
              <div class="newsletter-content">
                <!-- Section Title Start -->
                <div
                  class="section-title color-light text-center aos-init aos-animate"
                  data-aos="fade-up"
                >
                  <h2 class="title">Partner With Us Today</h2>
                  <p class="sub-title fz-18">
                    Ready to take your business to the next level? Partner with
                    us and experience seamless dropshipping.
                  </p>
                  <div class="newsletter-form">
                    <button class="btn btn-primary btn-hover-secondary">
                      Sign Up
                    </button>
                  </div>
                </div>
                <!-- Section Title End -->
              </div>
              <!-- Newsletter Content End -->
            </div>
          </div>
        </div>

        <!-- Animation Shape Start -->
        <div
          class="shape shape-1 scene"
          style="
            transform: translate3d(0px, 0px, 0px) rotate(0.0001deg);
            transform-style: preserve-3d;
            backface-visibility: hidden;
            pointer-events: none;
          "
        >
          <span
            data-depth="1"
            style="
              transform: translate3d(-116.4px, -5.1px, 0px);
              transform-style: preserve-3d;
              backface-visibility: hidden;
              position: relative;
              display: block;
              left: 0px;
              top: 0px;
            "
          >
            <img
              src="{{ asset('front/assets/images/shape-animation/newsletter-shape.png') }}"
              alt=""
            />
          </span>
        </div>
        <!-- Animation Shape End -->
      </div>

      <!--Sign up form end-->

      <!--contact us section Start-->
      <div class="section section-padding-t90-b100" id="contact">
        <div class="container shape-animate">
          <!-- Section Title Start -->
          <div
            class="section-title text-center mb-lg-12 mb-sm-8 mb-xs-8 aos-init aos-animate pt-15"
            data-aos="fade-up"
          >
            <h2 class="title">We are a full-service creative agency</h2>
            <p class="sub-title">
              Our team of designers, developers and creatives are perfectionists
              who love what they do and love where they work
            </p>
          </div>
          <!-- Section Title End -->

          <div
            class="row row-cols-lg-3 row-cols-md-2 row-cols-sm-2 row-cols-1 mb-n6"
          >
            <div
              class="col mb-6 aos-init aos-animate d-flex flex-column"
              data-aos="fade-up"
            >
              <!-- Contact Information Start -->
              <div class="contact-info" data-vivus-hover="">
                <div class="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="https://htmldemo.net/exomac/exomac/assets/images/svg/linea/linea-basic-map.svg"
                    class="svgInject"
                  >
                    <g>
                      <path
                        fill="none"
                        stroke="#000000"
                        stroke-width="2"
                        stroke-miterlimit="10"
                        d="M1,59L22,51L42,59L63,51L63,5L42,13L22,5L1,13Z"
                        style="stroke-dasharray: 225, 227; stroke-dashoffset: 0"
                      ></path>
                      <g>
                        <path
                          fill="none"
                          stroke="#000000"
                          stroke-width="2"
                          stroke-miterlimit="10"
                          d="M22,5L22,51"
                          style="stroke-dasharray: 46, 48; stroke-dashoffset: 0"
                        ></path>
                      </g>
                      <g>
                        <path
                          fill="none"
                          stroke="#000000"
                          stroke-width="2"
                          stroke-miterlimit="10"
                          d="M42,13L42,59"
                          style="stroke-dasharray: 46, 48; stroke-dashoffset: 0"
                        ></path>
                      </g>
                    </g>
                  </svg>
                </div>
                <div class="info">
                  <h4 class="title">Our Locations</h4>
                  <span class="info-text">
                    <a href="#" class="prevent-default">
                      214/1, kaduwela road <br />
                      battaramulla
                    </a>
                  </span>
                </div>
              </div>
              <!-- Contact Information End -->
            </div>
            <div
              class="col mb-6 aos-init aos-animate d-flex flex-column"
              data-aos="fade-up"
            >
              <!-- Contact Information Start -->
              <div class="contact-info" data-vivus-hover="">
                <div class="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="https://htmldemo.net/exomac/exomac/assets/images/svg/linea/linea-basic-message-txt.svg"
                    class="svgInject"
                  >
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M10,16L54,16"
                      style="stroke-dasharray: 44, 46; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M10,26L54,26"
                      style="stroke-dasharray: 44, 46; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M10,36L54,36"
                      style="stroke-dasharray: 44, 46; stroke-dashoffset: 0"
                    ></path>
                    <path
                      fill="none"
                      stroke="#000000"
                      stroke-width="2"
                      stroke-miterlimit="10"
                      d="M32,47L63,47L63,5L1,5L1,47L18,47L18,59Z"
                      style="stroke-dasharray: 225, 227; stroke-dashoffset: 0"
                    ></path>
                  </svg>
                </div>
                <div class="info">
                  <h4 class="title">Give Us A Call</h4>
                  <span class="info-text">
                    <a href="tel:0769242090"> 0769242090 </a>

                    <br />
                    <a href="tel:0113657102"> 0113657102 </a>
                  </span>
                </div>
              </div>
              <!-- Contact Information End -->
            </div>
            <div
              class="col mb-6 aos-init aos-animate d-flex flex-column"
              data-aos="fade-up"
            >
              <!-- Contact Information Start -->
              <div class="contact-info" data-vivus-hover="">
                <div class="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    xmlns:xlink="http://www.w3.org/1999/xlink"
                    version="1.1"
                    id="Layer_1"
                    x="0px"
                    y="0px"
                    width="64px"
                    height="64px"
                    viewBox="0 0 64 64"
                    enable-background="new 0 0 64 64"
                    xml:space="preserve"
                    data-inject-url="https://htmldemo.net/exomac/exomac/assets/images/svg/linea/linea-basic-mail-open-text.svg"
                    class="svgInject"
                  >
                    <g>
                      <path
                        fill="none"
                        stroke="#000000"
                        stroke-width="2"
                        stroke-miterlimit="10"
                        d="M36,9L45,9"
                        style="stroke-dasharray: 9, 11; stroke-dashoffset: 0"
                      ></path>
                      <path
                        fill="none"
                        stroke="#000000"
                        stroke-width="2"
                        stroke-miterlimit="10"
                        d="M19,17L45,17"
                        style="stroke-dasharray: 26, 28; stroke-dashoffset: 0"
                      ></path>
                      <path
                        fill="none"
                        stroke="#000000"
                        stroke-width="2"
                        stroke-miterlimit="10"
                        d="M19,25L45,25"
                        style="stroke-dasharray: 26, 28; stroke-dashoffset: 0"
                      ></path>
                      <g>
                        <path
                          fill="none"
                          stroke="#000000"
                          stroke-width="2"
                          stroke-miterlimit="10"
                          d="M1,26L32,45.434L63,26"
                          style="stroke-dasharray: 74, 76; stroke-dashoffset: 0"
                        ></path>
                        <path
                          fill="none"
                          stroke="#000000"
                          stroke-width="2"
                          stroke-miterlimit="10"
                          d="M11.334,21.667L1,26L1,63L63,63L63,26L63,26L52.666,21.667"
                          style="
                            stroke-dasharray: 159, 161;
                            stroke-dashoffset: 0;
                          "
                        ></path>
                        <path
                          fill="none"
                          stroke="#000000"
                          stroke-width="2"
                          stroke-miterlimit="10"
                          d="M11,32L11,1L53,1L53,32"
                          style="
                            stroke-dasharray: 104, 106;
                            stroke-dashoffset: 0;
                          "
                        ></path>
                      </g>
                    </g>
                  </svg>
                </div>
                <div class="info">
                  <h4 class="title">Help Desk</h4>
                  <span class="info-text">
                    <a href="mailto:sellercenter.24@gmail.com"
                      >sellercenter.24@gmail.com</a
                    >
                    <a href="mailto:Support@sellercenter.lk"
                      >support@sellercenter.lk</a
                    >

                    <a></a>
                  </span>
                </div>
              </div>
              <!-- Contact Information End -->
            </div>
          </div>

          <!-- Animation Shape Start -->
          <div
            class="shape shape-1 scene"
            style="
              transform: translate3d(0px, 0px, 0px) rotate(0.0001deg);
              transform-style: preserve-3d;
              backface-visibility: hidden;
              pointer-events: none;
            "
          >
            <span
              data-depth="4"
              style="
                transform: translate3d(56.4px, 62.4px, 0px);
                transform-style: preserve-3d;
                backface-visibility: hidden;
                position: relative;
                display: block;
                left: 0px;
                top: 0px;
              "
              ><img
                src="{{ asset('front/assets/images/shape-animation/video-shape-1.png') }}"
                alt="shape"
            /></span>
          </div>
          <!-- Animation Shape End -->
        </div>
      </div>
      <!--Contact us section End-->

      <!--google Map area start-->
      <div class="google-map-area section text-center section-padding-bottom">
        <div class="container">
          <div class="contact-map-area">
            <iframe
              src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15843.600633005699!2d79.9202797!3d6.9025423!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ae25a9155555567%3A0x3d7c57b04107878a!2sDailyDeals.lk!5e0!3m2!1sen!2slk!4v1717520116127!5m2!1sen!2slk"
              width="800"
              height="300"
              style="border: 0"
              allowfullscreen=""
              loading="lazy"
              referrerpolicy="no-referrer-when-downgrade"
            ></iframe>
            <!-- <iframe
              class="contact-map"
              src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2136.986005919501!2d-73.9685579655238!3d40.75862446708152!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c258e4a1c884e5%3A0x24fe1071086b36d5!2sThe%20Atrium!5e0!3m2!1sen!2sbd!4v1585132512970!5m2!1sen!2sbd"
              allowfullscreen=""
              aria-hidden="false"
              tabindex="0"
            ></iframe> -->
          </div>
        </div>
      </div>
      <!--Google map Area end-->

      <!--Contact Form Section Start-->
      <div id="register"
        class="contact-form-section section section-padding-t90-b100"
        data-bg-color="#f8faff"
        style="background-color: rgb(248, 250, 255)"
      >
        <div class="container">
          <div class="row">
            <div class="offset-lg-2 col-lg-8">
              <!-- Section Title Start -->
              <div
                class="section-title text-center aos-init aos-animate"
                data-aos="fade-up"
              >
                <h2 class="title fz-32">Start your journey with us</h2>
                <p class="sub-title">
                    Create New Account
                </p>
              </div>
              <!-- Section Title End -->
              <div class="contact-form">
                <form action="/sellerregister"  method="post" enctype="multipart/form-data">
                {{csrf_field()}}
                  <div class="row mb-n6">
                    <div class="col-md-12 col-12 mb-6">
                      <input type="text" placeholder="Your Name *" name="name" required/>
                    </div>
                    <div class="col-md-12 col-12 mb-6">
                      <input type="text" placeholder="Online Store Name *" name="company" required/>
                    </div>
                    <div class="col-md-12 col-12 mb-6">
                      <input type="email" placeholder="Email *" name="email" required/>
                    </div>
                    <div class="col-12 mb-6">
                      <textarea name="address" placeholder="Address"></textarea>
                    </div>
                    <div class="col-md-12 col-12 mb-6">
                      <input type="text" placeholder="Contact Number *" name="phone" required/>
                    </div>
                    <div class="col-md-12 col-12 mb-6">
                      <input type="password" placeholder="Password *" name="password" required/>
                    </div>
                    <div class="col-md-12 col-12 mb-6">
                        <label for="">Online Store Logo</label>
                        <input  name="img1" type="file" id="profile-img2" required>
                        <img src="" id="profile-img-tag2" width="200px" />   
                    </div>
                    <div class="col-12 text-center mb-6">
                      <button type="submit" class="btn btn-primary btn-hover-secondary"> Submit </button>
                    </div>
                  </div>
                </form>
                <p class="form-messege"></p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--Contact Form Section End-->
      <!--Footer Section Start-->
      <div
        class="footer-section section"
        data-bg-color="#000"
        data-bg-color="#030e22"
      >
        <div class="container">
          <!-- Footer Top Widgets Start -->

          <div class="row mb-lg-14 mb-md-10 mb-6">
            <!-- Footer Widget Start -->
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 col-12 mb-6">
              <div class="footer-widget pr-5">
                <div class="footer-logo">
                  <a href="index.html"
                    ><img
                      src="{{ asset('front/assets/images/logo/logo.png') }}"
                      alt="Agency Logo"
                      height="70px"
                  /></a>
                </div>
                <div class="footer-widget-content">
                  <div class="content">
                    <p>
                      We are your partner in success. We offer seamless
                      dropshipping solutions to help you grow your business
                      effortlessly
                    </p>
                  </div>
                </div>
              </div>
            </div>
            <!-- Footer Widget End -->

            <!-- Footer Widget Start -->
            <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-6 mb-6">
              <div class="footer-widget pl-lg-10">
                <h4 class="footer-widget-title">Our Services</h4>
                <div class="footer-widget-content">
                  <ul>
                    <li>
                      <a href="#" class="prevent-default">Manage Inventory</a>
                    </li>
                    <li>
                      <a href="#" class="prevent-default">
                        Introduce New Products</a
                      >
                    </li>
                    <li>
                      <a href="#" class="prevent-default">
                        Product Management</a
                      >
                    </li>
                    <li>
                      <a href="#" class="prevent-default"> Manage Orders</a>
                    </li>
                    <li>
                      <a href="#" class="prevent-default"> Manage Exchanges</a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
            <!-- Footer Widget End -->

            <!-- Footer Widget Start -->
            <div class="col-xl-2 col-lg-2 col-md-4 col-sm-4 col-6 mb-6">
              <div class="footer-widget">
                <h4 class="footer-widget-title">Useful Links</h4>
                <div class="footer-widget-content">
                  <ul>
                    <li><a href="#">Home</a></li>
                    <li><a href="#about">About Us</a></li>
                    <li>
                      <a href="#" class="prevent-default"
                        >Track Orders <span class="ft-badge">New</span></a
                      >
                    </li>
                    <li><a href="#">Sign Up</a></li>
                  </ul>
                </div>
              </div>
            </div>
            <!-- Footer Widget End -->

            <!-- Footer Widget Start -->
            <div class="col-xl-3 col-lg-3 col-md-4 col-sm-4 col-6 mb-6">
              <div class="footer-widget">
                <h4 class="footer-widget-title">Address</h4>
                <div class="footer-widget-content">
                  <div class="content">
                    <p><a href="tel:0769242090">0769242090 </a></p>
                    <p><a href="tel:0113657102">0113657102 </a></p>
                    <p>
                      <a href="mailto:sellercenter.24@gmail.com"
                        >sellercenter.24@gmail.com
                      </a>
                      <a href="mailto:support@sellercenter.lk"
                        >support@sellercenter.lk
                      </a>
                    </p>
                  </div>
                  <div class="footer-social-inline">
                    <a href="#"><i class="fab fa-twitter-square"></i></a>
                    <a
                      href="https://facebook.com/sellercenter.lk"
                      target="_blank"
                      ><i class="fab fa-facebook-square"></i
                    ></a>
                    <a href="#"><i class="fab fa-instagram"></i></a>
                  </div>
                </div>
              </div>
            </div>
            <!-- Footer Widget End -->
          </div>

          <!-- Footer Top Widgets End -->

          <!-- Footer Copyright Start -->
          <div class="row">
            <div class="col">
              <p class="copyright">
                © 2024
                <a href="sellercenter.lk">
                  <strong>Seller Center. </strong>
                </a>

                <strong>All Rights Reserved</strong>
              </p>
            </div>
          </div>
          <!-- Footer Copyright End -->
        </div>
      </div>
      <!--Footer Section End-->
      <!-- Scroll Top Start -->
      <a href="#" class="scroll-top" id="scroll-top">
        <i class="arrow-top fal fa-long-arrow-up"></i>
        <i class="arrow-bottom fal fa-long-arrow-up"></i>
      </a>
      <!-- Scroll Top End -->
    </div>

    <div id="site-main-mobile-menu" class="site-main-mobile-menu">
      <div class="site-main-mobile-menu-inner">
        <div class="mobile-menu-header">
          <div class="mobile-menu-logo">
            <a href="index.html"
              ><img src="{{ asset('front/assets/images/logo/logo.png') }}" alt="" height="50px"
            /></a>
          </div>
          <div class="mobile-menu-close">
            <button class="toggle">
              <i class="icon-top"></i>
              <i class="icon-bottom"></i>
            </button>
          </div>
        </div>
        <div class="mobile-menu-content">
          <nav class="site-mobile-menu">
            <ul>
              <li>
                <a href="/"><span class="menu-text">Home</span></a>
              </li>
              <li>
                <a href="#about"><span class="menu-text">About Us</span></a>
              </li>
              <li>
                <a href="#contact"><span class="menu-text">Contact Us</span></a>
              </li>
              <li>
                <a href="#register"><span class="menu-text">Register</span></a>
              </li>
              <li>
                <a href="/login"><span class="menu-text">Login</span></a>
              </li>
            </ul>
          </nav>
        </div>
      </div>
    </div>

    <!-- JS
============================================ -->

    <!-- Vendors JS -->
    <!-- <script src="assets/js/vendor/modernizr-3.6.0.min.js"></script>
<script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
<script src="assets/js/vendor/jquery-migrate-3.3.2.min.js"></script>
<script src="assets/js/vendor/bootstrap.bundle.min.js"></script> -->

    <!-- Plugins JS -->
    <!-- 
        <script src="assets/js/plugins/parallax.min.js"></script>
        <script src="assets/js/plugins/jquery.ajaxchimp.min.js"></script>
        <script src="assets/js/plugins/aos.min.js"></script>
        <script src="assets/js/plugins/imagesloaded.pkgd.min.js"></script>
        <script src="assets/js/plugins/isotope.pkgd.min.js"></script>
        <script src="assets/js/plugins/jquery.animatedheadline.min.js"></script>
        <script src="assets/js/plugins/jquery.counterup.min.js"></script>
        <script src="assets/js/plugins/jquery.magnific-popup.min.js"></script>
        <script src="assets/js/plugins/svg-inject.min.js"></script>
        <script src="assets/js/plugins/swiper.min.js"></script>
        <script src="assets/js/plugins/vanilla-tilt.min.js"></script>
        <script src="assets/js/plugins/vidim.min.js"></script>
        <script src="assets/js/plugins/vivus.min.js"></script>
        <script src="assets/js/plugins/waypoints.min.js"></script>

-->

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <script src="{{ asset('front/assets/js/vendor/vendor.min.js') }}"></script>
    <script src="{{ asset('front/assets/js/plugins/plugins.min.js') }}"></script>
    <script src="path/to/aos.js"></script>
    <script>
      AOS.init();
    </script>

    <!-- Main Activation JS -->
    <script src="{{ asset('dash/plugins/jquery/jquery.min.js') }}"></script>
<!-- jQuery UI 1.11.4 -->
<script src="{{ asset('dash/plugins/jquery-ui/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('front/assets/js/main.js') }}"></script>
    <script src="{{ asset('dash/plugins/toastr/toastr.min.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('dash/plugins/sweetalert2/sweetalert2.min.css') }}">

    <!--Prevent Default behavior of not linked links-->
    <script>
      document.querySelectorAll(".prevent-default").forEach(function (element) {
        element.addEventListener("click", function (event) {
          event.preventDefault();
        });
      });
    </script>
  </body>
</html>
<script>
@if (session('success'))
        // swal("Success!","{{session('success')}}","success");
        toastr.success("Success!","{{session('success')}}","success")
        // toastr.success('Congratulations, Your Account Has Been Successfully Created!')
// Swal.fire({
  
//   type: 'success',
//   title: 'Your work has been saved',
//   text: "{{session('success')}}",
//   showConfirmButton: false,
//   timer: 1500
// });


@endif
@if (session('error'))
    swal({
            title: "Error!",
            text: "{{session('error')}}",
            icon: "error",
            button: "OK",
        });
@endif

</script>