<?php echo $__env->make('dashboard.include.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Delivery Rider App</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <!-- <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Delivery Status Change</li> -->
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <div class="row">
          <div class="col-md-12">
                <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size:12px;">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Name</th>
                            <th>Delivery Date</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Product</th>
                            <th>COD</th>
                            <th>Note</th>
                            <th>Status</th>
                            <th>Print</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $item; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($data->id); ?></td>
                            <td><?php echo e($data->name); ?></td>
                            <td>
                            <?php if($data->deliverydate==$ldate): ?>
                            <span class="badge badge-info">Today</span>
                            <?php else: ?>
                            <?php echo e($data->deliverydate); ?>

                            <?php endif; ?>
                            </td>
                            <td><?php echo e($data->address); ?></td>
                            <td><a href="tel:<?php echo e($data->phone); ?>"><?php echo e($data->phone); ?></a>/<a href="tel:<?php echo e($data->secondaryphone); ?>"><?php echo e($data->secondaryphone); ?></a></td>
                            <td>
                            <?php $__currentLoopData = $data->cus_or; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($pro->qty); ?> <b>*</b> <?php echo e($pro->orders->name); ?>,
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <td><?php echo e($data->cod); ?></td>
                            <td><?php echo e($data->note); ?></td>
                            <td class="text-center">
                            <?php if($data->deliverystatus=='0'): ?>
                            <span class="badge badge-warning">Not Delivery</span>
                            <?php elseif($data->deliverystatus=='1'): ?>
                            <span class="badge badge-success">Delivered</span>
                            <?php elseif($data->deliverystatus=='21'): ?>
                            <span class="badge badge-warning">Not Delivery</span>
                            <?php endif; ?>
                            </td>
                            <td>
                            <?php if($data->print=="0"): ?>
                            <span class="badge badge-warning">Not Print</span>
                            <?php else: ?>
                            <span class="badge badge-success">Printed</span>
                            <?php endif; ?>
                            </td>
                            <td class="text-center">                            
                            <button type="button" data-id="<?php echo e($data->id); ?>" data-date="<?php echo e($data->deliverydate); ?>" data-rider="<?php echo e($data->ridername); ?>" data-status="<?php echo e($data->deliverystatus); ?>"  class="btn btn-success btn-xs" data-toggle="modal" data-target="#editmodeldate">Date</button>
                            &nbsp;
                            <button type="button" data-id="<?php echo e($data->id); ?>" data-date="<?php echo e($data->deliverydate); ?>" data-rider="<?php echo e($data->ridername); ?>" data-note="<?php echo e($data->note); ?>" data-status="<?php echo e($data->deliverystatus); ?>"  class="btn btn-info btn-xs" data-toggle="modal" data-target="#editordermodel">Update</button>
                            </td>
                            
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Id</th>
                            <th>Name</th>
                            <th>Delivery Date</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Product</th>
                            <th>COD</th>
                            <th>Note</th>
                            <th>Status</th>
                            <th>Print</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
          </div>
          </div>
        </div>
      </div>
    </section>
  </div>

    <div class="modal fade" id="editmodeldate" role="dialog">
        <div class="modal-dialog">
        
          <!-- Modal content-->
          <div class="modal-content">
            <div class="modal-header">
                    <h4 class="modal-title">Update Delivery Details</h4>
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              
            </div>
            
            <form method="post" enctype="multipart/form-data" action="/riderdeliverydate">
            <?php echo e(csrf_field()); ?>

                <div class="modal-body">
                <input type="hidden" id="id1" name="id">

              <div class="form-group">
                    <label for="">Delivery Date :</label>                        
                        <div class="input-group date" id="reservationdate" data-target-input="nearest">
                            <input type="text" class="form-control datetimepicker-input" value="" id="delivery_date" name="delivery_date" data-target="#reservationdate"/  required>
                            <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                </div>

                </div>
           
            <div class="modal-footer">
            <input type="submit" name="btnform1" id="action" class="btn btn-primary right" value="Submit"/>
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
            </form>
          </div>
          
        </div>

</div>


 
  <div class="modal fade" id="editordermodel" role="dialog">
        <div class="modal-dialog">
        
          <!-- Modal content-->
          <div class="modal-content">
            <div class="modal-header">
                    <h4 class="modal-title">Update Delivery Details</h4>
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              
            </div>
            
            <form method="post" enctype="multipart/form-data" action="/riderdeliveryupdate">
            <?php echo e(csrf_field()); ?>

                <div class="modal-body">
                <input type="hidden" id="id" name="id">
                <div class="form-group">
                    <label>Assign Rider</label>
                        <select class="form-control" name="deliveryrid" id="deliveryrid" required>
                            <?php $__currentLoopData = $delise; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($data->type=="Delivery_Guy"): ?>
                            <option value="<?php echo e($data->id); ?>"><?php echo e($data->name); ?></option>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                </div>
                <div class="form-group">
                    <label>Order Status</label>
                        <select class="form-control" name="statusdelauth" id="statusdelauth" required>
                            <option value="12">Assign Rider</option>
                            <option value="21">Not Delivery</option>
                            <option value="18">Delivered</option>
                            <option value="10">Cancel</option>
                        </select>
                </div>
                <div class="form-group">
                  <label>Reason</label>
                  <textarea type="text" placeholder="" value="" id="note" rows="2" name="note" class="form-control" required></textarea>
              </div>

                </div>
           
            <div class="modal-footer">
            <input type="submit" name="btnform1" id="action" class="btn btn-primary right" value="Submit"/>
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
            </form>
          </div>
          
        </div>

</div>



  <?php echo $__env->make('dashboard.include.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<script>
$(function () {
    $("#example12").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 7, "asc" ]],
      "buttons": ["colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
  });

$('#reservationdate').datetimepicker({
    format: 'YYYY/MM/DD'
    });

</script>

<script>

$('#editmodeldate').on('show.bs.modal', function (event) {

var button = $(event.relatedTarget) // Button that triggered the modal

var id = button.data('id') 
var date = button.data('date') 

var modal = $(this)

modal.find('.modal-body #id1').val(id)
modal.find('.modal-body #delivery_date').val(date)




})


$('#editordermodel').on('show.bs.modal', function (event) {

var button = $(event.relatedTarget) // Button that triggered the modal

var id = button.data('id') 
var status = button.data('status') 
var note1 = button.data('note') 
var date = button.data('date') 
var rider = button.data('rider') 
var modal = $(this)

modal.find('.modal-body #id').val(id)
// modal.find('.modal-body #note').val(note1)
modal.find('.modal-body #delivery_date').val(date)
$("#statusdelauth").val(status).change();
$("#deliveryrid").val(rider).change();

})
</script>