<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title>Vibrant Technologies | Dashboard</title>
  <link rel="shortcut icon" href="<?php echo e(asset('dash/dist/img/AdminLTELogo.png')); ?>">
  <!-- <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback"> -->

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Open+Sans&display=swap" rel="stylesheet">


  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/fontawesome-free/css/all.min.css')); ?>">
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/select2/css/select2.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/jqvmap/jqvmap.min.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('dash/dist/css/adminlte.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/overlayScrollbars/css/OverlayScrollbars.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/daterangepicker/daterangepicker.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/summernote/summernote-bs4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/ekko-lightbox/ekko-lightbox.css')); ?>">
    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/sweetalert2/sweetalert2.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('dash/plugins/toastr/toastr.min.css')); ?>">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <!-- Preloader -->
  <div class="preloader flex-column justify-content-center align-items-center">
    <img class="animation__shake" src="<?php echo e(asset('dash/dist/img/AdminLTELogo.png')); ?>" alt="AdminLTELogo" height="60" width="60">
  </div>

  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
    </ul>

    <form class="form-inline ml-3" action="/searchresult" method="post">
    <?php echo e(csrf_field()); ?>

      <div class="input-group input-group-sm">
        <input class="form-control form-control-navbar" name="invoiceno" type="search" placeholder="Invoice ID + Enter Key" aria-label="Search">
      </div>
      <button type="submit" formtarget="_blank" style="display: none;"></button>
    </form>

    <form class="form-inline ml-3" action="/searchbarcodehe" method="post">
    <?php echo e(csrf_field()); ?>

      <div class="input-group input-group-sm">
        <input class="form-control form-control-navbar" name="invoiceno" type="search" placeholder="Barcode + Enter Key" aria-label="Search">
      </div>
      <button type="submit" formtarget="_blank" style="display: none;"></button>
    </form>

    <?php if(Auth::user()->email=="ashan.mal@gmail.com" OR Auth::user()->email=="amanda@dailydeals.lk" OR Auth::user()->email=="mjayanatha@gmail.com"): ?>
    <form class="form-inline ml-3" action="/gotoeditpage" method="post">
    <?php echo e(csrf_field()); ?>

      <div class="input-group input-group-sm">
        <input class="form-control form-control-navbar" name="invoiceno" type="search" placeholder="Go To Edit Page" aria-label="Search">
      </div>
      <button type="submit" formtarget="_blank" style="display: none;"></button>
    </form>
    <?php endif; ?>

    <ul class="navbar-nav ml-auto">

      <li class="nav-item">
        <a class="nav-link" data-widget="fullscreen" href="#" role="button">
          <i class="fas fa-expand-arrows-alt"></i>
        </a>
      </li>
      <li class="nav-item dropdown">
        <a id="dropdownSubMenu1" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="nav-link dropdown-toggle"><?php echo e(Auth::user()->name); ?></a>
        <ul aria-labelledby="dropdownSubMenu1" class="dropdown-menu border-0 shadow">
          <li><a href="/userprofile" class="dropdown-item">Profile</a></li>
          <li><a href="/useredit" class="dropdown-item">Profile Settings</a></li>
          <li class="dropdown-divider"></li>
          <!-- Level two dropdown-->
          <li>
          <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
          <i class="fas fa-sign-out-alt"></i> Log Out    
            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
               <?php echo e(csrf_field()); ?>

            </form>
        </a>
          </li>
          <!-- End Level two -->
        </ul>
      </li>
      <!-- <li class="nav-item">
        <a class="nav-link" data-widget="control-sidebar" data-slide="true" href="#">
          <i class="fas fa-th-large"></i>
        </a>
      </li> -->
    </ul>
  </nav>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4" >
    <!-- Brand Logo -->
    <a href="/home" class="brand-link">
      <img src="<?php echo e(asset('dash/dist/img/AdminLTELogo.png')); ?>" alt="AdminLTE Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
      <span class="brand-text font-weight-light" style="font-size:17px">Vibrant Technologies</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">

      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
          <?php if((Auth::user()->type=="Delivery_Guy")): ?>
          <li class="nav-item">
            <a href="/deliverystatus" id="home1" class="nav-link"><i class="nav-icon fas fa-tachometer-alt"></i><p>Delivery Status</p></a>
          </li>
          <?php elseif((Auth::user()->type=="Call_center")): ?>
          <li class="nav-item">
            <a href="/home" id="home1" class="nav-link"><i class="nav-icon fas fa-tachometer-alt"></i><p>Dashboard</p></a>
          </li>
          <li id="menu1" class="nav-item">
          <a href="#" id="val1" class="nav-link"><i class="nav-icon fas fa-phone-square-alt"></i><p>Call Center<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
              <li class="nav-item"><a href="/viewpending" id="valin1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Pending Orders</p></a></li>
              <li class="nav-item"><a href="/1stattempt" id="valin2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>1st Attempt Orders</p></a></li>
              <li class="nav-item"><a href="/2ndattempt" id="valin3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>2nd Attempt Orders</p></a></li>
              <li class="nav-item"><a href="/3rdattempt" id="valin4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>3rd Attempt Orders</p></a></li>
              <li class="nav-item"><a href="/phoneoff" id="valin5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Phone Off</p></a></li>
              <li class="nav-item"><a href="/hewillcall" id="valin6" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>He will call</p></a></li>
              <li class="nav-item"><a href="/hold" id="valin7" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Hold Orders</p></a></li>
              <li class="nav-item"><a href="/reject" id="valin8" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Reject Orders</p></a></li>
              <li class="nav-item"><a href="/bannedcustomers" id="valin9" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Banned Orders</p></a></li>
              <li class="nav-item"><a href="/half" id="valin10" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Incomplete Orders</p></a></li>
            </ul>
          </li>
          <li id="menu4" class="nav-item">
          <a href="#" id="val4" class="nav-link"><i class="nav-icon fa fa-indent"></i><p>Manage Orders<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/addorder" id="order7" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Add Order</p></a></li>
            <li class="nav-item"><a href="/allorders" id="order6" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>All Orders</p></a></li>
              <li class="nav-item"><a href="/returnorders" id="order2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Return Orders</p></a></li>
              <li class="nav-item"><a href="/cancelorders" id="order3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Cancel Orders</p></a></li>
              <li class="nav-item"><a href="/dropexordersdispatch" id="order7" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dropex Orders</p></a></li>
              <li class="nav-item"><a href="/dispatchwholesale" id="order8" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Wholesale Dispatched</p></a></li>
              <li class="nav-item"><a href="/completeorders" id="order4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dispatched Orders</p></a></li>
              <li class="nav-item"><a href="/paidorders" id="order5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Money Recive Orders</p></a></li>
              <li class="nav-item"><a href="/bulkdelivery" id="order10" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Bulk Delivery Mark</p></a></li>
              <li class="nav-item"><a href="/remindorders" id="order11" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Remind Orders</p></a></li>
              
            </ul>
          </li>

          <?php elseif((Auth::user()->type=="Inventory")): ?>

          <li id="menu2" class="nav-item">
          <a href="#" id="val2" class="nav-link"><i class="nav-icon fa fa-truck"></i><p>Confirm Orders<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/dropexorders" id="valshi5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dropex Orders</p></a></li>
            <li class="nav-item"><a href="/colomboorder" id="valshi1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Colombo Orders</p></a></li>
            <li class="nav-item"><a href="/todayconfirm" id="valshi2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Out Orders</p></a></li>
            <li class="nav-item"><a href="/colomboprint" id="valshi3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Colombo Orders Print</p></a></li>
            <li class="nav-item"><a href="/todayprint" id="valshi4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Out Orders Print</p></a></li>
            </ul>
          </li>
          <li id="menu3" class="nav-item">
          <a href="#" id="val3" class="nav-link"><i class="nav-icon fa fa-server"></i><p>Packing<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/inventorycolombo" id="inven1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Colombo Packing</p></a></li>
            <li class="nav-item"><a href="/inventorytoday" id="inven2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Out Packing</p></a></li>
            <li class="nav-item"><a href="/packwholesale" id="inven7" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Whole Sale Packing</p></a></li>
            <li class="nav-item"><a href="/dispatchsummary" id="inven6" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dispatch Summary</p></a></li>
            <li class="nav-item"><a href="/returnrecive" id="inven3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Return Recive</p></a></li>
            <!-- <li class="nav-item"><a href="/remainingstock" id="inven4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Remaining Stock</p></a></li> -->
            <li class="nav-item"><a href="/damageitem" id="inven5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Damage Item</p></a></li>
            
            </ul>
          </li>
          <?php elseif((Auth::user()->type=="Recovery")): ?>
          <li class="nav-item">
            <a href="/home" id="home1" class="nav-link"><i class="nav-icon fas fa-tachometer-alt"></i><p>Dashboard</p></a>
          </li>
          <li id="menu1" class="nav-item">
          <a href="#" id="val1" class="nav-link"><i class="nav-icon fas fa-phone-square-alt"></i><p>Call Center<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
              <li class="nav-item"><a href="/viewpending" id="valin1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Pending Orders</p></a></li>
              <li class="nav-item"><a href="/1stattempt" id="valin2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>1st Attempt Orders</p></a></li>
              <li class="nav-item"><a href="/2ndattempt" id="valin3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>2nd Attempt Orders</p></a></li>
              <li class="nav-item"><a href="/3rdattempt" id="valin4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>3rd Attempt Orders</p></a></li>
              <li class="nav-item"><a href="/phoneoff" id="valin5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Phone Off</p></a></li>
              <li class="nav-item"><a href="/hewillcall" id="valin6" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>He will call</p></a></li>
              <li class="nav-item"><a href="/hold" id="valin7" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Hold Orders</p></a></li>
              <li class="nav-item"><a href="/reject" id="valin8" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Reject Orders</p></a></li>
              <li class="nav-item"><a href="/bannedcustomers" id="valin9" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Banned Orders</p></a></li>
              <li class="nav-item"><a href="/half" id="valin10" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Incomplete Orders</p></a></li>
           
            </ul>
          </li>
          <li id="menu2" class="nav-item">
          <a href="#" id="val2" class="nav-link"><i class="nav-icon fa fa-truck"></i><p>Confirm Orders<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/dropexorders" id="valshi5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dropex Orders</p></a></li>
            <li class="nav-item"><a href="/colomboorder" id="valshi1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Colombo Orders</p></a></li>
            <li class="nav-item"><a href="/todayconfirm" id="valshi2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Out Orders</p></a></li>
            <li class="nav-item"><a href="/colomboprint" id="valshi3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Colombo Orders Print</p></a></li>
            <li class="nav-item"><a href="/todayprint" id="valshi4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Out Orders Print</p></a></li>
            </ul>
          </li>
          <li id="menu4" class="nav-item">
          <a href="#" id="val4" class="nav-link"><i class="nav-icon fa fa-indent"></i><p>Manage Orders<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/allorders" id="order6" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>All Orders</p></a></li>
              <li class="nav-item"><a href="/returnorders" id="order2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Return Orders</p></a></li>
              <li class="nav-item"><a href="/cancelorders" id="order3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Cancel Orders</p></a></li>
              <li class="nav-item"><a href="/completeorders" id="order4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dispatched Orders</p></a></li>
              <li class="nav-item"><a href="/dropexordersdispatch" id="order7" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dropex Orders</p></a></li>
              <li class="nav-item"><a href="/dispatchwholesale" id="order8" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Wholesale Dispatched</p></a></li>
              <li class="nav-item"><a href="/paidorders" id="order5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Money Recive Orders</p></a></li>
              <li class="nav-item"><a href="/bulkdelivery" id="order10" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Bulk Delivery Mark</p></a></li>
              <li class="nav-item"><a href="/remindorders" id="order11" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Remind Orders</p></a></li>
              
            </ul>
          </li>

          <?php else: ?>
          <li class="nav-item">
            <a href="/home" id="home1" class="nav-link"><i class="nav-icon fas fa-tachometer-alt"></i><p>Dashboard</p></a>
          </li>

          <!-- <li class="nav-item menu-open"> -->
          <li id="menu1" class="nav-item">
          <a href="#" id="val1" class="nav-link"><i class="nav-icon fas fa-phone-square-alt"></i><p>Call Center<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
              <li class="nav-item"><a href="/viewpending" id="valin1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Pending Orders</p></a></li>
              <li class="nav-item"><a href="/1stattempt" id="valin2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>1st Attempt Orders</p></a></li>
              <li class="nav-item"><a href="/2ndattempt" id="valin3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>2nd Attempt Orders</p></a></li>
              <li class="nav-item"><a href="/3rdattempt" id="valin4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>3rd Attempt Orders</p></a></li>
              <li class="nav-item"><a href="/phoneoff" id="valin5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Phone Off</p></a></li>
              <li class="nav-item"><a href="/hewillcall" id="valin6" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>He will call</p></a></li>
              <li class="nav-item"><a href="/hold" id="valin7" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Hold Orders</p></a></li>
              <li class="nav-item"><a href="/reject" id="valin8" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Reject Orders</p></a></li>
              <li class="nav-item"><a href="/bannedcustomers" id="valin9" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Banned Orders</p></a></li>
              <li class="nav-item"><a href="/half" id="valin10" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Incomplete Orders</p></a></li>
            
            </ul>
          </li>
          <li id="menu2" class="nav-item">
          <a href="#" id="val2" class="nav-link"><i class="nav-icon fa fa-truck"></i><p>Confirm Orders<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/dropexorders" id="valshi5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dropex Orders</p></a></li>
            <li class="nav-item"><a href="/colomboorder" id="valshi1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Colombo Orders</p></a></li>
            <li class="nav-item"><a href="/todayconfirm" id="valshi2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Out Orders</p></a></li>
            <li class="nav-item"><a href="/colomboprint" id="valshi3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Colombo Orders Print</p></a></li>
            <li class="nav-item"><a href="/todayprint" id="valshi4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Out Orders Print</p></a></li>
            </ul>
          </li>
          <li id="menu3" class="nav-item">
          <a href="#" id="val3" class="nav-link"><i class="nav-icon fa fa-server"></i><p>Packing<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/inventorycolombo" id="inven1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Colombo Packing</p></a></li>
            <li class="nav-item"><a href="/inventorytoday" id="inven2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Out Packing</p></a></li>
            <li class="nav-item"><a href="/packwholesale" id="inven7" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Whole Sale Packing</p></a></li>
            <li class="nav-item"><a href="/dispatchsummary" id="inven6" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dispatch Summary</p></a></li>
            <li class="nav-item"><a href="/returnrecive" id="inven3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Return Recive</p></a></li>
            <!-- <li class="nav-item"><a href="/remainingstock" id="inven4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Remaining Stock</p></a></li> -->
            <li class="nav-item"><a href="/damageitem" id="inven5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Damage Item</p></a></li>
            
            </ul>
          </li>
          <li id="menu4" class="nav-item">
          <a href="#" id="val4" class="nav-link"><i class="nav-icon fa fa-indent"></i><p>Manage Orders<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/allorders" id="order6" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>All Orders</p></a></li>
              <li class="nav-item"><a href="/returnorders" id="order2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Return Orders</p></a></li>
              <li class="nav-item"><a href="/cancelorders" id="order3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Cancel Orders</p></a></li>
              <li class="nav-item"><a href="/completeorders" id="order4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dispatched Orders</p></a></li>
              <li class="nav-item"><a href="/dropexordersdispatch" id="order7" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Dropex Orders</p></a></li>
              <li class="nav-item"><a href="/dispatchwholesale" id="order8" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Wholesale Dispatched</p></a></li>
              <li class="nav-item"><a href="/paidorders" id="order5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Money Recive Orders</p></a></li>
              <li class="nav-item"><a href="/bulkdelivery" id="order10" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Bulk Delivery Mark</p></a></li>
              <li class="nav-item"><a href="/remindorders" id="order11" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Remind Orders</p></a></li>
              
            </ul>
          </li>

          <li id="menu5" class="nav-item">
          <a href="#" id="val5" class="nav-link"><i class="nav-icon fa fa-plus-square"></i><p> Add Orders<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
              <li class="nav-item"><a href="/importorders" id="add1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Import Order</p></a></li>
              <li class="nav-item"><a href="/addorder" id="add2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Add Order</p></a></li>
              <li class="nav-item"><a href="/addwholesale" id="add3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Whole Sale</p></a></li>
            </ul>
          </li>

          <li id="menu9" class="nav-item">
          <a href="#" id="val9" class="nav-link"><i class="nav-icon fas fa-cash-register"></i><p> Accounts<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
              <li class="nav-item"><a href="/grnmanage" id="acc10" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>GRN</p></a></li>
              <li class="nav-item"><a href="/colombodelivery" id="acc1" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Riders Payment Receive</p></a></li>
              <li class="nav-item"><a href="/courierpayment" id="acc2" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Courier Payment Receive</p></a></li>
              <li class="nav-item"><a href="/storepickupmoneyreceived" id="acc11" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Store Pickup Payment</p></a></li>
              <li class="nav-item"><a href="/accountswholesale" id="acc8" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Wholesale Payment Receive</p></a></li>
              <li class="nav-item"><a href="/supplierpayment" id="acc3" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Supplier Payments</p></a></li>
              <li class="nav-item"><a href="/salary" id="acc4" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Salary Payments</p></a></li>
              <li class="nav-item"><a href="/chequemanage" id="acc9" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Cheque Manage</p></a></li>
              <li class="nav-item"><a href="/tansactionentery" id="acc5" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Transaction</p></a></li>
              <li class="nav-item"><a href="/transaction" id="acc7" class="nav-link">&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Transaction History</p></a></li>
            </ul>
          </li>


          <?php if((Auth::user()->type=="super_admin")): ?>
          <li id="menu6" class="nav-item">
            <a href="#" id="pro6" class="nav-link"><i class="nav-icon fa fa-window-maximize"></i><p>Product<i class="fas fa-angle-left right"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/updateproduct" id="prod1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Add Product</p></a></li>
            <li class="nav-item"><a href="/remainingstock" id="prod2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Remaining Stock</p></a></li>
            <li class="nav-item"><a href="/productpurchasing" id="prod3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Generate Barcode</p></a></li>
            <!-- <li class="nav-item"><a href="/genaratebarcode" id="prod4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Generate Barcode</p></a></li> -->
            
            </ul>
          </li>
          <li id="menu8" class="nav-item">
            <a href="#" id="opt8" class="nav-link"><i class="nav-icon fa fa-cog"></i><p>Add Options<i class="fas fa-angle-left right"></i></p></a>
            <ul class="nav nav-treeview">
            <li class="nav-item"><a href="/pageregister" id="opti1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Add Pages</p></a></li>
            <li class="nav-item"><a href="/supplier" id="opti2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Add Supplier</p></a></li>
            <li class="nav-item"><a href="/deliveryserice" id="opti3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Add Deliver Service</p></a></li>
            <li class="nav-item"><a href="/wholesale" id="opti4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Add Wholesaler</p></a></li>
            <li class="nav-item"><a href="/companybank" id="opti5" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Add Bank</p></a></li>
            <li class="nav-item"><a href="/addbannedcustomers" id="opti6" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Add Banned Customer</p></a></li>
            </ul>
          </li>
          <?php endif; ?>
          <li id="menu7" class="nav-item">
            <a href="#" id="user7" class="nav-link"><i class="nav-icon far fa-user-circle"></i><p>User<i class="fas fa-angle-left right"></i></p></a>
            <ul class="nav nav-treeview">
            <?php if((Auth::user()->type=="super_admin")): ?>
            <li class="nav-item"><a href="/userprofile" id="userin1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>User Profile</p></a></li>
              <li class="nav-item"><a href="/register" id="userin2" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>User Register</p></a></li>
              <li class="nav-item"><a href="/usermange" id="userin3" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>User Mange</p></a></li>
              <li class="nav-item"><a href="/useredit" id="userin4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Edit Profile</p></a></li>
            <?php else: ?>
            <li class="nav-item"><a href="/userprofile" id="userin1" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>User Profile</p></a></li>
            <li class="nav-item"><a href="/useredit" id="userin4" class="nav-link">&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-angle-double-right nav-icon"></i><p>Edit Profile</p></a></li>
            <?php endif; ?>
            <?php endif; ?>
              
            </ul>
          </li>
        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <?php if((Auth::user()->type=="Call_center")): ?>
  <script>
  $(function(){
    var current = window.location.pathname;
    if(current=='/addorder'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order7' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
  });

</script>

  <?php endif; ?>
  <script>
  $(function(){
    var current = window.location.pathname;
        if(current=='/home'){
            // $this.addClass('active');
            var elem = document.getElementById( 'home1' );
            elem.classList.add('active');
        }
        else if(current=='/viewpending'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/1stattempt'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/2ndattempt'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/3rdattempt'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin4' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/phoneoff'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin5' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/hewillcall'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin6' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/hold'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin7' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/reject'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin8' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/bannedcustomers'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin9' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/half'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin10' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/colomboorder'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/dropexorders'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi5' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/searchdeliverydate'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/todayconfirm'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/todayconfirmsearch'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/colomboprint'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/colomboprintfilter'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/todayprint'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi4' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/searchoutprint'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi4' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/register'){
          var elem1 = document.getElementById( 'menu7' );
          var elem2 = document.getElementById( 'user7' );
          var elem3 = document.getElementById( 'userin2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/usermange'){
          var elem1 = document.getElementById( 'menu7' );
          var elem2 = document.getElementById( 'user7' );
          var elem3 = document.getElementById( 'userin3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/useredit'){
          var elem1 = document.getElementById( 'menu7' );
          var elem2 = document.getElementById( 'user7' );
          var elem3 = document.getElementById( 'userin4' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/userprofile'){
          var elem1 = document.getElementById( 'menu7' );
          var elem2 = document.getElementById( 'user7' );
          var elem3 = document.getElementById( 'userin1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }


         else if(current=='/inventorycolombo'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/searchinventorycolombo2'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }

        else if(current=='/inventorytoday'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/inventorytoday2'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/packwholesale'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven7' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/packwholesale2'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven7' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/wholesalefilter'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven7' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/returnrecive'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/remainingstock'){
          var elem1 = document.getElementById( 'menu6' );
          var elem2 = document.getElementById( 'pro6' );
          var elem3 = document.getElementById( 'prod2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/damageitem'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven5' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }

        else if(current=='/colombodelivery'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/grnmanage'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc10' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/courierpayment'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/storepickupmoneyreceived'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc11' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/storepickupfilter'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc11' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/accountswholesale'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc8' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/supplierpayment'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/purchesingfilter'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/salary'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc4' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/chequemanage'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc9' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/chequemangefilter'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc9' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/tansactionentery'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc5' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/transaction'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc7' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/paymentrecovecolomboserch'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }

        else if(current=='/dispatchsummary'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven6' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/returnorders'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/cancelorders'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/completeorders'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order4' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/dropexordersdispatch'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order7' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/dispatchwholesale'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order8' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/paidorders'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order5' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/bulkdelivery'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order10' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/remindorders'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order11' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/remindfilter'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order11' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/allorders'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order6' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }


        else if(current=='/importorders'){
          var elem1 = document.getElementById( 'menu5' );
          var elem2 = document.getElementById( 'val5' );
          var elem3 = document.getElementById( 'add1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/addorder'){
          var elem1 = document.getElementById( 'menu5' );
          var elem2 = document.getElementById( 'val5' );
          var elem3 = document.getElementById( 'add2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }

        else if(current=='/addwholesale'){
          var elem1 = document.getElementById( 'menu5' );
          var elem2 = document.getElementById( 'val5' );
          var elem3 = document.getElementById( 'add3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }


        else if(current=='/updateproduct'){
          var elem1 = document.getElementById( 'menu6' );
          var elem2 = document.getElementById( 'pro6' );
          var elem3 = document.getElementById( 'prod1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/remainingstock'){
          var elem1 = document.getElementById( 'menu6' );
          var elem2 = document.getElementById( 'pro6' );
          var elem3 = document.getElementById( 'prod2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/productpurchasing'){
          var elem1 = document.getElementById( 'menu6' );
          var elem2 = document.getElementById( 'pro6' );
          var elem3 = document.getElementById( 'prod3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/genaratebarcode'){
          var elem1 = document.getElementById( 'menu6' );
          var elem2 = document.getElementById( 'pro6' );
          var elem3 = document.getElementById( 'prod4' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }




        else if(current=='/pageregister'){
          var elem1 = document.getElementById( 'menu8' );
          var elem2 = document.getElementById( 'opt8' );
          var elem3 = document.getElementById( 'opti1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/supplier'){
          var elem1 = document.getElementById( 'menu8' );
          var elem2 = document.getElementById( 'opt8' );
          var elem3 = document.getElementById( 'opti2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/deliveryserice'){
          var elem1 = document.getElementById( 'menu8' );
          var elem2 = document.getElementById( 'opt8' );
          var elem3 = document.getElementById( 'opti3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/companybank'){
          var elem1 = document.getElementById( 'menu8' );
          var elem2 = document.getElementById( 'opt8' );
          var elem3 = document.getElementById( 'opti5' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/addbannedcustomers'){
          var elem1 = document.getElementById( 'menu8' );
          var elem2 = document.getElementById( 'opt8' );
          var elem3 = document.getElementById( 'opti6' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        else if(current=='/wholesale'){
          var elem1 = document.getElementById( 'menu8' );
          var elem2 = document.getElementById( 'opt8' );
          var elem3 = document.getElementById( 'opti4' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }




        var domain = window.location.pathname.split('/');
        // alert(domain[domain.length - 2]);
        var dopath = (domain[domain.length - 2]);
        var dopath2 = (domain[domain.length - 1]);
        if(dopath2=='viewaddorder'){
          var elem1 = document.getElementById( 'menu5' );
          var elem2 = document.getElementById( 'val5' );
          var elem3 = document.getElementById( 'add2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='viwedetails'){
          var elem1 = document.getElementById( 'menu1' );
          var elem2 = document.getElementById( 'val1' );
          var elem3 = document.getElementById( 'valin1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='viwedetailsship'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='viwedetailsconfirm'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order6' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='viewallorders'){
          var elem1 = document.getElementById( 'menu4' );
          var elem2 = document.getElementById( 'val4' );
          var elem3 = document.getElementById( 'order6' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='viwedetailsinventory'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }

        if(dopath=='courierexcel'){
          var elem1 = document.getElementById( 'menu3' );
          var elem2 = document.getElementById( 'val3' );
          var elem3 = document.getElementById( 'inven6' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }




        if(dopath=='productattribute'){
          var elem1 = document.getElementById( 'menu6' );
          var elem2 = document.getElementById( 'pro6' );
          var elem3 = document.getElementById( 'prod1' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='viewbarcode'){
          var elem1 = document.getElementById( 'menu6' );
          var elem2 = document.getElementById( 'pro6' );
          var elem3 = document.getElementById( 'prod2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='supplierdetails'){
          var elem1 = document.getElementById( 'menu8' );
          var elem2 = document.getElementById( 'opt8' );
          var elem3 = document.getElementById( 'opti2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='trackingrange'){
          var elem1 = document.getElementById( 'menu8' );
          var elem2 = document.getElementById( 'opt8' );
          var elem3 = document.getElementById( 'opti3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='viwedetailsshipconfirm'){
          var elem1 = document.getElementById( 'menu2' );
          var elem2 = document.getElementById( 'val2' );
          var elem3 = document.getElementById( 'valshi4' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='purchasingdetails'){
          var elem1 = document.getElementById( 'menu6' );
          var elem2 = document.getElementById( 'pro6' );
          var elem3 = document.getElementById( 'prod3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='receivedetails'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc2' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }
        if(dopath=='wholesalerprodetails'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc8' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }

        if(dopath=='supplierproductdetails'){
          var elem1 = document.getElementById( 'menu9' );
          var elem2 = document.getElementById( 'val9' );
          var elem3 = document.getElementById( 'acc3' );
          elem1.classList.add('menu-open');
          elem2.classList.add('active');
          elem3.classList.add('active');
        }

});

  </script>


<style>
.timeline {
    border-left: 3px solid #727cf5;
    border-bottom-right-radius: 4px;
    border-top-right-radius: 4px;
    background: rgba(114, 124, 245, 0.09);
    margin: 0 auto;
    letter-spacing: 0.2px;
    position: relative;
    line-height: 1.4em;
    font-size: 1.03em;
    padding: 50px;
    list-style: none;
    text-align: left;
    max-width: 40%;
}

@media (max-width: 767px) {
    .timeline {
        max-width: 98%;
        padding: 25px;
    }
}

.timeline h1 {
    font-weight: 300;
    font-size: 1.4em;
}

.timeline h2,
.timeline h3 {
    font-weight: 600;
    font-size: 1rem;
    margin-bottom: 10px;
}

.timeline .event {
    border-bottom: 1px dashed #e8ebf1;
    padding-bottom: 25px;
    margin-bottom: 25px;
    position: relative;
}

@media (max-width: 767px) {
    .timeline .event {
        padding-top: 30px;
    }
}

.timeline .event:last-of-type {
    padding-bottom: 0;
    margin-bottom: 0;
    border: none;
}

.timeline .event:before,
.timeline .event:after {
    position: absolute;
    display: block;
    top: 0;
}

.timeline .event:before {
    left: -207px;
    content: attr(data-date);
    text-align: right;
    font-weight: 100;
    font-size: 0.9em;
    min-width: 120px;
}

@media (max-width: 767px) {
    .timeline .event:before {
        left: 0px;
        text-align: left;
    }
}

.timeline .event:after {
    -webkit-box-shadow: 0 0 0 3px #727cf5;
    box-shadow: 0 0 0 3px #727cf5;
    left: -55.8px;
    background: #fff;
    border-radius: 50%;
    height: 9px;
    width: 9px;
    content: "";
    top: 5px;
}

@media (max-width: 767px) {
    .timeline .event:after {
        left: -31.8px;
    }
}

.rtl .timeline {
    border-left: 0;
    text-align: right;
    border-bottom-right-radius: 0;
    border-top-right-radius: 0;
    border-bottom-left-radius: 4px;
    border-top-left-radius: 4px;
    border-right: 3px solid #727cf5;
}

.rtl .timeline .event::before {
    left: 0;
    right: -170px;
}

.rtl .timeline .event::after {
    left: 0;
    right: -55.8px;
}
</style>