<?php echo $__env->make('dashboard.include.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

  
  <div class="content-wrapper" style="">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Bank Transaction History</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Bank Transaction History</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <form method="post" id="formFilter" class="formFilter">
          <?php echo e(csrf_field()); ?>

          <div class="row">


            <div class="col-md-4">
              <div class="form-group">
                <label>Select Bank</label>
                <select class="form-control" name="bank" id="bank" style="width: 100%;" required>
                    <option value="" selected="selected" disabled>Select</option>
                    <?php $__currentLoopData = $supdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supdatadata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($supdatadata->id); ?>"><?php echo e($supdatadata->accountname); ?> - <?php echo e($supdatadata->bank); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            </div>

            <div class="col-md-4">
              <div class="form-group">
                <label>Account Option</label>
                <select class="form-control" name="accoption" id="accoption" style="width: 100%;" required>
                        <option value="all">All</option>
                    <?php $__currentLoopData = $accoption; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accoptiondata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($accoptiondata->option); ?>"><?php echo e($accoptiondata->option); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                <label>Date Range</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                    <span class="input-group-text">
                        <i class="far fa-calendar-alt"></i>
                    </span>
                    </div>
                    <input type="text" class="form-control float-right" id="reservation" value="" name="daterange">
                </div>
                </div>

            </div>


          </div>
          </form>
        </div>
      </div>



      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table data-page-length='25' id="example12" class="table table-striped table-hover" style="width:100%; font-size:11px;">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <!-- <th>User</th> -->
                            <th>Date</th>
                            <th>Description</th>
                            <th>Withdrawal</th>
                            <th>Deposit</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  <?php echo $__env->make('dashboard.include.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>;



<script>
  $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

$('#reservation').change(function(){
    $('#example12').DataTable().ajax.reload();
});



    $('#bank').change(function() {
      $('#example12').DataTable().ajax.reload();
    });
    
    $('#accoption').change(function() {
      $('#example12').DataTable().ajax.reload();
    });



$(document).ready(function() {
  var table = $('#example12').DataTable({
        "ajax": {   "url": '/getbanktransaction',
                    "type": 'POST',
                    "data": function ( d ) {
                    return $('.formFilter').serialize();
                    }
        },
        columns: [
            { data: 'id', name: 'id' },
            // { data: 'user', name: 'user' },
            { data: 'created_at', name: 'created_at' },
            { data: 'note', name: 'note'},
            { data: 'withdrawal', name: 'withdrawal'},
            { data: 'deposit', name: 'deposit' },
            { data: 'balance', name: 'balance', orderable: false, searchable: false}
        ],
        "order": [[ 0, "desc" ]]
    });
} );


setInterval(function(){
  $('#example12').DataTable().ajax.reload();
}, 20000);



</script>








